/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "transform3.h"

/*-----------------------------------------------------------------------
 * Function:	determinant
 * Description:	compute the determinant of a transform, using an already
 *		  computed adjoint transform
 * Args:	T: the transform (INPUT)
 *		Tadj: T's adjoint transform (INPUT)
 * Returns:	det(T)
 * Author:	hanrahan, mbp
 * Date:	Thu Aug  8 15:23:53 1991
 * Notes:	
 */
static
float
determinant( T, Tadj )
    Transform3 T, Tadj;
{
    float det;

    det = T[0][0]*Tadj[0][0] 
        + T[0][1]*Tadj[1][0] 
        + T[0][2]*Tadj[2][0] 
        + T[0][3]*Tadj[3][0];

    return det;
}

/*-----------------------------------------------------------------------
 * Function:	Tm3Invert
 * Description:	compute the inverse of a transform
 * Args:	T: the transform (INPUT)
 *		Tinv: the inverse transform (OUTPUT)
 * Returns:	det(T)
 * Author:	mbp
 * Date:	Thu Aug  8 15:25:01 1991
 * Notes:	If T is singular, we set Tinv to the adjoint of T
 *		  and return 0.
 */
float
Tm3Invert( T, Tinv )
    Transform3 T, Tinv;
{
    float det;

    Tm3Adjoint( T, Tinv );
    
    det = determinant( T, Tinv );

    if( det != 0.0 ) {
	register Tm3Coord *p = &Tinv[0][0];
	register int i = 4*4;
	det = 1. / det;
	do { *p++ *= det; } while(--i > 0); /* Scale all elements by 1/det */
    }

    return det;
}

/*-----------------------------------------------------------------------
 * Function:	Tm3Determinant
 * Description:	compute the determinant of a transform
 * Args:	T: the transform (INPUT)
 * Returns:	det(T)
 * Author:	mbp
 * Date:	Thu Aug  8 15:27:52 1991
 * Notes:	
 */
float
Tm3Determinant( T )
    Transform3 T;
{
    Transform3 Tadj;

    Tm3Adjoint( T, Tadj );

    return determinant( T, Tadj );
}
