/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "transform3.h"

/*-----------------------------------------------------------------------
 * Function:	Tm3Transpose
 * Description:	transpose a matrix
 * Args:	T: the matrix to transpose (INPUT)
 *		Ttrans: the transposed matrix (OUTPUT)
 * Returns:	nothing
 * Author:	hanrahan, mbp
 * Date:	Thu Aug  8 14:41:24 1991
 * Notes:	
 */
void
Tm3Transpose( T, Ttrans )
    Transform3 T, Ttrans;
{
    register int i, j;
    double t;

    if( T != Ttrans ) {
        for( i=0; i<4; i++ )
            for( j=0; j<4; j++ )
                Ttrans[i][j] = T[j][i];
    }
    else {
        for( i=0; i<4; i++ ) 
            for( j=0; j<i; j++ ) {
                t = T[i][j];
                T[i][j] = T[j][i];
                T[j][i] = t;
            }
    }
}

/*-----------------------------------------------------------------------
 * Function:	Tm3Dual
 * Description:	compute the dual of a matrix
 * Args:	T: the matrix to compute the dual of (INPUT)
 *		Tdual: the dual matrix (OUTPUT)
 * Returns:	nothing
 * Author:	mbp
 * Date:	Thu Aug  8 14:43:24 1991
 * Notes:	dual = transpose of adjoint matrix
 */
void
Tm3Dual( T, Tdual )
    Transform3 T, Tdual;
{
    Tm3Adjoint( T, Tdual );
    Tm3Transpose( Tdual, Tdual );
}

