/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "transform3.h"

void
Tm3AlignX( T, axis )
    Transform3 T;
    HPoint3 *axis;
{
    Tm3Align( T, axis, (HPoint3 *)&TM3_XAXIS );
}

void
Tm3AlignY( T, axis )
    Transform3 T;
    HPoint3 *axis;
{
    Tm3Align( T, axis, (HPoint3 *)&TM3_YAXIS );
}

void
Tm3AlignZ( T, axis )
    Transform3 T;
    HPoint3 *axis;
{
    Tm3Align( T, axis, (HPoint3 *)&TM3_ZAXIS );
}

void
Tm3Align( T, axis, newaxis )
    Transform3 T;
    HPoint3 *axis, *newaxis;
{
    Transform3 Tr;
    Transform3 Tinv;
    HPoint3 o, zaxis, yaxis, newyaxis;
    
    o.x = o.y = o.z = 0.; o.w = 1.;

    Pt3Cross( axis, newaxis, &zaxis );

    Pt3Cross( &zaxis, axis, &yaxis );
    Pt3Cross( &zaxis, newaxis, &newyaxis );

    Pt3Unit(axis);
    Pt3Unit(&yaxis);
    Pt3Unit(&zaxis);

    axis->w = yaxis.w = zaxis.w = 0.;
    Tm3Tetrad( T, axis, &yaxis, &zaxis, &o );
    Tm3Invert( T, Tinv );

    Pt3Unit(newaxis);
    Pt3Unit(&newyaxis);

    newaxis->w = newyaxis.w = zaxis.w = 0.;

    Tm3Tetrad( Tr, newaxis, &newyaxis, &zaxis, &o );

    Tm3Concat(Tinv, Tr, Tr);
    Tm3Copy( Tr, T );
}
