/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "transform3.h"

static 
double 
det( a1, a2, a3, b1, b2, b3, c1, c2, c3 )
    double a1, a2, a3;
    double b1, b2, b3;
    double c1, c2, c3;
{
    return a1*(b2*c3-c2*b3) - a2*(b1*c3-c1*b3) + a3*(b1*c2-c1*b2);
}

static
double 
determinant( matrix )
    Tm3Coord matrix[3][3];
{
    return det( matrix[0][0], matrix[0][1], matrix[0][2],
                matrix[1][0], matrix[1][1], matrix[1][2],
                matrix[2][0], matrix[2][1], matrix[2][2] );
}

static
double 
cofactor( T, x, y )
    Tm3Coord T[4][4];
    int x, y;
{
    static Tm3Coord mat3x3[9];
    register Tm3Coord *dst = mat3x3;
    register Tm3Coord *src = T[0];
    int i, j;

    for( i=0; i<4; i++ )
        for( j=0; j<4; j++ ) {
            if( i != x && j != y ) *dst++ = *src;
            src++;
        }
    return determinant( mat3x3 );
}


static
void
adjoint( T, Tadj )
    Transform3 T, Tadj;
{
    register int x, y;
    double cof;

    for( x=0; x<4; x++ )
	for( y=0; y<4; y++ ) {
	    cof = cofactor( T, y, x );
	    Tadj[x][y] = ((x+y)&1) ? -cof : cof;
	}
}

/*-----------------------------------------------------------------------
 * Function:	Tm3Adjoint
 * Description:	compute the adjoint of a transform
 * Args:	T: the transform (INPUT)
 *		Tadj: the adjoint of T (OUTPUT)
 * Returns:	nothing
 * Author:	hanrahan, mbp
 * Date:	Thu Aug  8 15:38:56 1991
 * Notes:	
 */
void
Tm3Adjoint( T, Tadj )
    Transform3 T, Tadj;
{
    if( T == Tadj ) {
	Transform3 Ttmp;

	adjoint( T, Ttmp );
	Tm3Copy( Ttmp, Tadj );
    }
    else
	adjoint( T, Tadj );
}

