/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef POINT3DEFS
#define POINT3DEFS
/*
** Definitions for 3D float points:
*/

typedef float Pt3Coord;
typedef struct { Pt3Coord x, y, z; } Point3;

extern void Pt3Print(/* Point3 *p */);
extern void Pt3From(/* Point3 *p, Pt3Coord x, y, z */);
extern void Pt3Copy(/* Point3 *a, *b */);

extern void Pt3Add(/* Point3 *a, *b, *c */);
extern void Pt3Sub(/* Point3 *a, *b, *c */);
extern void Pt3Neg(/* Point3 *a, *b */);
extern void Pt3Mul(/* Pt3Coord s, Point3 *a, *b */);
extern void Pt3Comb(/* Pt3Coord sa, Point3 *a, Pt3Coord sb, Point3 *b, *c */);
extern void Pt3Lerp(/* Pt3Coord a, Point3 *a, *b, *c */);

extern Pt3Coord Pt3Dot(/* Point3 *a, *b */);
extern void Pt3Cross(/* Point3 *a, *b, *c */);
extern Pt3Coord Pt3TripleDot(/* Point3 *a, *b, *c */);
extern void Pt3TripleCross(/* Point3 *a, *b, *c, *d */);

extern Pt3Coord Pt3Distance(/* Point3 *a, *b */);
extern Pt3Coord Pt3Length(/* Point3 *p */);
extern Pt3Coord Pt3Angle(/* Point3 *a, *b */);

extern int Pt3Equal(/* Point3 *a, *b */);
extern int Pt3Parallel(/* Point3 *a, *b */);
extern int Pt3Perpendicular(/* Point3 *a, *b */);

/* Note -- this was incorrect -- there is only one arg
   Tamara Munzner 7/17/90 */
extern void Pt3Unit(/* Point3 *a */);

extern void Pt3Transform(/* Transform3 T, Point3 *a, *b */);
extern void Pt3TransformN(/* Transform3 T, Point3 *a, *b, int n */);

extern Point3 Pt3Origin;

#define Pt3X(pt) (pt)->x
#define Pt3Y(pt) (pt)->y
#define Pt3Z(pt) (pt)->z

float SgSgDistance(Point3 *a1, Point3 *a2,
		   Point3 *b1, Point3 *b2);


#endif
