#include "vec4.h"
#include <geom.h>
#include <color.h>
#include <point.h>
#include "trigrp.h"

extern ColorA GetCmapEntry();


	/* order is: 2,3,6 */
	/* use 4-tuples so can use library routines on them */
Transform reftri[NUMGRPS]  = {
   {	/* 233 */
	{1., 0., 0., 1.}, 
	{0.57735, 0.816497, 0., 1.}, 
    	{0.57735, 0., 0.816497, 1.},
	{0,0,0,1}},
   { 	/* 234 */
	{1., 0., 0., 1.}, 
	{0.816497, 0.57735, 0., 1.}, 
     	{0.707107, 0., 0.707107, 1.},
	{0,0,0,1}},
   {	/* 235 */
	{1., 0., 0., 1.}, 
	{0.934172, 0.356822, 0., 1.}, 
    	{0.850651, 0., 0.525731, 1.},
	{0,0,0,1}},
    {	/* 236 */
	{0,0,0,1}, 
	{.5,0,0,1}, 
	{0,.866025,0,1},
	{0,0,1,0}},
    {	/* 237 */
	{0.49697043, 0., 0., 1.}, 
	{0.49697043, 0.23932834, 0., 1.}, 
	{0., 0., 0., 1.},
	{0,0,1,0}}
	};

Transform reftritp[NUMGRPS];
	/* gl routines expect pointers to floats !!???!! */
	float t236[3][4] = {
	 {0,0,0,1}, 
	 {.5,0,0,1}, 
	 {0,.866025,0,1}};

	Transform	ireftri[NUMGRPS];	
	Transform  gens[NUMGRPS][3] = {	/* 4 groups, 3 gens apiece */
	{	/* 233 */
    {
	{0., 0.70710678, 0.70710678, 0.}, 
	{0.70710678, 0.5, -0.5, 0.}, 
     	{0.70710678, -0.5, 0.5, 0.}, 
	{0., 0., 0., 1.}}, 
    {
	{1., 0., 0., 0.}, 
	{0., -1., 0., 0.}, 
	{0., 0., 1., 0.}, 
	{0., 0., 0., 1.}}, 
    {
	{1., 0., 0., 0.}, 
	{0., 1., 0., 0.}, 
     	{0., 0., -1., 0.}, 
	{0., 0., 0., 1.}}}, 
   {{
	{0.5, 0.70710678, 0.5, 0.}, 
	{0.70710678, 0., -0.70710678, 0.}, 
     	{0.5, -0.70710678, 0.5, 0.}, 
	{0., 0., 0., 1.}}, 
    {
	{1., 0., 0., 0.}, 
	{0., -1., 0., 0.}, 
	{0., 0., 1., 0.}, 
     	{0., 0., 0., 1.}}, 
   {
	{1., 0., 0., 0.}, 
	{0., 1., 0., 0.}, 
     	{0., 0., -1., 0.}, 
	{0., 0., 0., 1.}}}, 
   {{
	{0.80901699, 0.5, 0.30901699, 0.}, 
	{0.5, -0.30901699, -0.80901699, 0.}, 
     	{0.30901699, -0.80901699, 0.5, 0.}, 
	{0., 0., 0., 1.}}, 
    {
	{1., 0., 0., 0.}, 
	{0., -1., 0., 0.}, 
	{0., 0., 1., 0.}, 
     	{0., 0., 0., 1.}}, 
    {
	{1., 0., 0., 0.}, 
	{0., 1., 0., 0.}, 
     	{0., 0., -1., 0.}, 
	{0., 0., 0., 1.}}
	},

	{	/* 236 */
	 {{-0.5, -0.866026, 0, 0.}, 
	  {-0.866026, 0.5, 0, 0.}, 
	  {0., 0, 1, 0.}, 
   	  {0.75, 0.433013, 0, 1.}},
	 {{-1,0,0,0},
	  {0,1,0,0},
	  {0,0,1,0},
	  {0,0,0,1}},
	 {{1,0,0,0},
	  {0,-1,0,0},
	  {0,0,1,0},
	  {0,0,0,1}}},
	{	/* 237 */
	 {{0.6234898, 0.78183148, 0., 0.}, 
	  {0.78183148, -0.6234898, 0., 0.}, 
   	  {0., 0., 1., 0.}, 
	  {0., 0., 0., 1.}}, 
  	 {{1., 0., 0., 0.}, 
	  {0., -1., 0., 0.}, 
	  {0., 0., 1., 0.}, 
	  {0., 0., 0., 1.}}, 
  	 {{-1.6559706, 0., 0., -1.3199388}, 
	  {0., 1., 0., 0.}, 
	  {0., 0., 1., 0.}, 
   	  {1.3199388, 0., 0., 1.6559706}},
/*
  	 {{-0.5, 0.8660254, 0., 0.}, 
	  {0.8660254, 0.5, 0., 0.}, 
	  {0., 0., 1., 0.}, 
   	  {0., 0., 0., 1.}},
	 {{-1.3201547, 0., 0., -0.86186338}, 
	  {0., 1., 0., 0.}, 
	  {0., 0., 1., 0.}, 
   	  {0.86186338, 0., 0., 1.3201547}}, 
   	 {{1., 0., 0., 0.}, 	
	  {0., -1., 0., 0.}, 	
	  {0., 0., 1., 0.}, 	
	  {0., 0., 0., 1.}}, 
*/
	}
	};

Geom *plist = NULL;
Geom *eucplist = NULL;

compute_gen()
{
	/* compute the inverse of the reference tri cord system */
	int i, j;
	Transform mm;
	HPoint3 pp1, pp2;
	for (i=0;i<NUMGRPS; ++i) {
		/*TmTranspose(reftri[i], reftritp[i]);*/
		TmInvert(reftri/*tp*/[i], ireftri[i]);
		/* matrices are in the wrong orientation for hg routines */
		/*for (j=0; j<3; ++j)	{
			TmTranspose(gens[i][j], mm);
			TmCopy(mm, gens[i][j]);
		}
		*/
	}
}

HPoint3 points[7];	/* Vertices in fundamental domain */

Geom *
Make2nmFD(bary, active_group, plptr)
HPoint3 bary;
Geom *plptr;
{
    HPoint3 pp, p2, pn, pm;
    Hg4Coord *tp, *tq;	/* images of the point */
    float total;
    int i;

    if (active_group >= 0 && active_group < 3)	{	/* spherical triangle */
	Line l1, l2, l3;
	static HPoint3 origin = {0,0,0,1};
	HPoint3 vertex,pt, pp2;
	Plane pl;

	PtTransform(reftri/*tp*/[active_group],  &bary, &pp);	
	tp = (Hg4Coord *) &pp;
	NORMALIZE3( tp );  pp.w = 1.0;
	PtTransform(gens[active_group][0],&pp, &p2);
	tq = (Hg4Coord *) &p2;
	MIDPOINT4( tp, tq, tq)
	PtTransform(gens[active_group][1], &pp,&pn);
	tq = (Hg4Coord *)&pn;
	MIDPOINT4(tp, tq, tq)
	PtTransform(gens[active_group][2],&pp,&pm);
	tq = (Hg4Coord *) &pm;
	MIDPOINT4(tp, tq, tq)

	/* in spherical groups, truncate the corner vertices */
	HLn3From2HPt3s(&l2, reftri[active_group][0], &origin);
	/* compute plane equation for pp,pn,pm */
	HLn3From2HPt3s(&l1, &pp, &pn);
	LnDual(&l1, &l1);
	Hg4AntiContractPijQj(&l1, &pm, &pl);
	LnIntersectPl(&l2, &pl, &pp2);
	Hg4Normalize(&pp2,&pp2);
	points[0] = pp2;
    
	HLn3From2HPt3s(&l2, reftri[active_group][1], &origin);
	/* compute plane equation for pp,pn,pm */
	HLn3From2HPt3s(&l1, &pp, &pm);
	LnDual(&l1, &l1);
	Hg4AntiContractPijQj(&l1, &p2, &pl);
	LnIntersectPl(&l2, &pl, &pp2);
	Hg4Normalize(&pp2,&pp2);
	points[1] = pp2;
    
	HLn3From2HPt3s(&l2, reftri[active_group][2], &origin);
	/* compute plane equation for pp,pn,pm */
	HLn3From2HPt3s(&l1, &pp, &p2);
	LnDual(&l1, &l1);
	Hg4AntiContractPijQj(&l1, &pn, &pl);
	LnIntersectPl(&l2, &pl, &pp2);
	Hg4Normalize(&pp2,&pp2);
	points[2] = pp2;
    
    } else if (active_group == G_236)	{
	PtTransform(reftri/*tp*/[active_group],  &bary, &pp);	
	tp = (Hg4Coord *) &pp;
	PtTransform(gens[active_group][0],&pp, &p2);
	tq = (Hg4Coord *) &p2;
	MIDPOINT4( tp, tq, tq)
	PtTransform(gens[active_group][1], &pp,&pn);
	tq = (Hg4Coord *) &pn;
	MIDPOINT4(tp, tq, tq)
	PtTransform(gens[active_group][2],&pp,&pm);
	tq = (Hg4Coord *) &pm;
	MIDPOINT4(tp, tq, tq)
	for (i=0; i<3; ++i)
	    points[i] = *(HPoint3 *)reftri[active_group][i];
    } else {	/* hyperbolic */
	/* need to replace these midpoint routines with genuine hyp stuff */
	PtTransform(reftri/*tp*/[active_group],  &bary, &pp);	
	tp = (Hg4Coord *) &pp;
	Hg4Normalize(tp,tp);

	PtTransform(gens[active_group][0],&pp, &p2);
	tq = (Hg4Coord *) &p2;
	midpoint31( tp, tq, tq);
	PROJECT4(tq);

	PtTransform(gens[active_group][1], &pp,&pn);
	tq = (Hg4Coord *)&pn;
	midpoint31(tp, tq, tq);
	PROJECT4(tq);

	PtTransform(gens[active_group][2],&pp,&pm);
	tq = (Hg4Coord *) &pm;
	midpoint31(tp, tq, tq);
	PROJECT4(tq);


	for (i=0; i<3; ++i)
	    points[i] = *(HPoint3 *)reftri[active_group][i];
    }

    /* stuff 4 moving vertices into struct */
    /* order is :  pp, p2, pn, pm */
    points[3] = pp;
    points[4] = p2;
    points[5] = pn;
    points[6] = pm;
    GeomCCreate(plptr, (GeomClass *)NULL, CR_POINT4, points, CR_END);
}

extern Geom *obj[];

	/* this is the indices of the vertices inthe 3 quads we produce */
static table[3][4] = {
	5,3,6,0,
	4,1,6,3,
	5,2,4,3
};

init_plist(active_group)
{
    int i,j;
    static int threequads[3] = { 4,4,4 };
    ColorA facecolors[3];
    extern GeomClass *PolyListMethods();

    for (i=0; i<3; ++i)
	points[i] = *(HPoint3 *)reftri[active_group][i];

    for (i=3; i<7; ++i)			/* Clone distinguished point */
	points[i] = points[0];

    if (plist == NULL)	{
	for(i = 0; i < 3; i++)
	    facecolors[i] = GetCmapEntry(i);

	plist = GeomCCreate(NULL, PolyListMethods(),
		CR_NPOLY, 3,
		CR_NVERT, threequads,
		CR_VERT, table,
		CR_POLYCOLOR, facecolors,
		CR_POINT4, points,
		CR_END);
	eucplist = GeomCopy(plist);
    } else {
	/* Update vertices */
	GeomCCreate(plist, (GeomClass *)NULL,  CR_POINT4, points, CR_END);
    }
}

midpoint31(p0,p1,m)
Hg4Coord *p0, *p1, *m;
{
    float m0,m1;
    int i;
    Hg4Coord p2[4];

    VSUB4(p0, p1, p2)
    if (VISZERO4(p2))	
	VCOPY4(p0, m)
    else
	{
	m0 = INPRO31(p0, p2);
	m1 = INPRO31(p1, p2);
	for (i=0; i<4; ++i)	
		m[i] = m1*p0[i] - m0*p1[i];
	}
}
