/*  todo:   add menu with choice of groups: now icosa,octa, tetra 
 */
#include <stdio.h>
#include <geom.h>
#include "vec4.h"
#include "trigrp.h"
#include <mg.h>
#include <window.h>
#include <appearance.h>
#include <color.h>

#include <gl/gl.h>
#include <gl/device.h>

#ifdef AARG
	/* Use Pixar aarg command-line argument handler if AARG defined. */
#include <aarg.h>
#include <aarg.i.h>
#define	main(argc,argv)  remain(argc,argv)

#endif /*AARG*/


extern char *getenv();

/*	Barycentric:	convert from 236 triangle coordinate system
		to barycentric coordinate system:
		(1,0,0,0):	pi/2
		(0,1,0,0):	pi/3
		(0,0,1,0):	pi/6
 	Input:		a point in the same coordinate system as
		the global variable reftri
 */
	
#define Barycentric(src,dst) PtTransform(ireftri[G_236],&src,&dst);	\
	fprintf(stderr,"Barycentric: %f %f %f %f\n",dst.x,dst.y,dst.z,dst.w);
#define PI	3.1415926

char *progname;
FILE *toviewer = stdout;
char cmapfile[128] = "";
extern char *grpnames[];
extern Geom *plist;
extern Geom *eucplist;
extern char *group_path;
static Geom *fd;
extern Geom *Make2nmFD();

int debug = 0, batch = 0, stop = 1,active_group = 0, which = 0,
	    automatic = 0, newgroup = 1;
int menu;
WnPosition wp;

HPoint3 ppoint = {0.15, 0.4, 0.0, 1.0}, bary;
static HPoint3 vel = {.005, .008, 0, 0};
static Transform LineTri;
extern Transform reftri[], ireftri[], gens[][3]; 
extern float t236[][4];

static int initmenu();

double
MyDot(p0,p1)
float *p0, *p1;
{
    return(p0[0]*p1[0] + p0[1]*p1[1] + p0[2]*p1[2] + p0[3]*p1[3]);
}
void
init_Lines()
{
    int i;
    LineTri[0][0] = reftri[G_236][1][1] - reftri[G_236][2][1];
    LineTri[0][1] = -reftri[G_236][1][0] + reftri[G_236][2][0];
    LineTri[0][3] = reftri[G_236][1][0]*reftri[G_236][2][1] -
			reftri[G_236][2][0]*reftri[G_236][1][1];
    LineTri[1][0] = reftri[G_236][2][1] - reftri[G_236][0][1];
    LineTri[1][1] = -reftri[G_236][2][0] + reftri[G_236][0][0];
    LineTri[1][3] = reftri[G_236][2][0]*reftri[G_236][0][1] -
			reftri[G_236][0][0]*reftri[G_236][2][1];
    LineTri[2][0] = reftri[G_236][0][1] - reftri[G_236][1][1];
    LineTri[2][1] = -reftri[G_236][0][0] + reftri[G_236][1][0];
    LineTri[2][3] = reftri[G_236][0][0]*reftri[G_236][1][1] -
			reftri[G_236][1][0]*reftri[G_236][0][1];
    LineTri[0][2] = LineTri[1][2] = LineTri[2][2] = 0.0;
}
	
int
GetOrigin(pt)
register HPoint3 *pt;
{
    /* simple solution now */
    int x,y;
    float px, py;

    int reverse = 0;
    /* only look when the left mouse button's down */
    x = getvaluator(MOUSEX);
    if (x > wp.xmax  || x < wp.xmin) return(0);
    x = x - wp.xmin ;	/* 0-1 range */
    px = (XMAX - XMIN) * (x/((double) (wp.xmax-wp.xmin+1))) + XMIN;
    y = getvaluator(MOUSEY);
    if (y > wp.ymax  || y < wp.ymin) return(0);
    y = y - wp.ymin;	/* 0-1 range */
    py = (YMAX - YMIN) * (y/((double) (wp.ymax-wp.ymin+1))) + YMIN;
    if(px == pt->x && py == pt->y)
	return 0;
    pt->x = px;
    pt->y = py;
    return(1);
}

static
SendFD()
{
    fprintf(toviewer, "(read geometry { define fd ");
      GeomFSave(plist, toviewer, "stdout");
    fprintf(toviewer, "} )\n");
    fflush(toviewer);
}

static
SendGroup()
{
    fprintf(toviewer,
		"(geometry trigrp { = INST tlist < %s/%s.prj unit : fd })",
		group_path, grpnames[active_group]);
    fflush(toviewer);
}

main(argc, argv)
char **argv;
{
 	int  i, n,m, count = 1;
        short val, dev;
	char *term = getenv("TERM");

	progname = argv[0];
	active_group = G_236;

	if (!batch)
	  if(term == NULL || strcmp(term, "iris-ansi") != 0) {
	    fprintf(stderr,"Not on an iris-ansi terminal, unsafe to use windows\n");
	    batch = 1;
	}
	init_groups();
	readcmap(cmapfile);
	/* and initialize polylist structure */
	init_plist(active_group);
	init_Lines();

    /* in interactive mode, init graphics for inputting distinguished point */
    if (!batch)	{
	static Color gray = {.8,.8,.8};

        foreground();
	mgdevice_GL();
        mgctxcreate(MG_WnSet, WN_NAME, "trigrp", WN_END,
		    MG_CamSet, CAM_PERSPECTIVE, 0,
				CAM_FOCUS, 1.,
				CAM_HALFYFIELD, .5, CAM_END,
		    MG_ApSet, AP_DO, APF_FACEDRAW|APF_EDGEDRAW,
				AP_SHADING, APF_CONSTANT, AP_END,
		    MG_BACKGROUND, &gray,
		    MG_END);

	mgreshapeviewport();
        initmouse();
	menu = initmenu();
	PtTransform(ireftri[G_236],&ppoint,&bary);
        drawframe();
	fprintf(stderr,"Trigrp: use left button to drag meeting point, right button for menu.\n");
	}
	
	i = 0;
	if (!batch) {
	  while (1) {	/* if interactive, continue forever */
	    if(newgroup) {
		drawframe();
		fd = Make2nmFD(bary, active_group, plist);
		SendFD();
		SendGroup();
		newgroup = 0;
	    }
    	    if (automatic) {
		ppoint.x += vel.x;
		ppoint.y += vel.y;
		for (i=0; i<3; ++i) {
		    /* is bouncing point outside triangle ? */
	    	    if (MyDot(&ppoint, LineTri[i]) < 0) 	{
	        	PtTransform(gens[G_236][i], &ppoint, &ppoint); 
	        	PtTransform(gens[G_236][i], &vel, &vel); 
			i = 3;
		    }
		}
		drawframe();
		PtTransform(ireftri[G_236],&ppoint,&bary);
	        fd = Make2nmFD(bary, active_group, plist);
	    	SendFD();
	  	sginap(20);
	    }
	    if (!automatic || qtest()) {
	    	  dev = qread(&val);
		  switch(dev)	{
		    case LEFTMOUSE:
		    case MIDDLEMOUSE:
			automatic = 0;
			do {
			    if(GetOrigin(&ppoint)) {
				PtTransform(ireftri[G_236],&ppoint,&bary);
				fd = Make2nmFD(bary, active_group, plist);
				SendFD();
				drawframe();
			    }
			    sginap(20);
			} while(getbutton(dev));
			break;
	    	    case KEYBD:	
		      switch(val)	{
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			    active_group = val - '3';
			    newgroup = 2;
			    break;
			case 'a':
			    automatic = 1 - automatic;
			    break;
			case 'p':
			    fprintf(stderr,"Barycentric: %f %f %f %f\n",bary.x,bary.y,bary.z,bary.w);
			    break;

			case '\033':
			case 'Q':
				gexit(); exit(1);	/* Quit */
			}
			break;
	   	    case MENUBUTTON:
		    if( val ) {
		      switch(val = dopup(menu)) {
			case 0: 
			case 1: 
			case 2: 
			case 3: 
			case 4: 
			    active_group = val;
			    newgroup = 2;
			    break;
			case 5:
			fprintf(stderr,"Barycentric: %f %f %f %f\n",bary.x,bary.y,bary.z,bary.w);
			    break;
			case 6: 
			    automatic = 1 - automatic;
			    break;
			case 7: exit(1); break;	/* Quit */
		      }
		    }
		    break;
		    case REDRAW:
			mgreshapeviewport();
			initmouse();
			drawframe();
			break;
		    }
		}
	    }
	} else {
	    fd = Make2nmFD(bary, active_group, plist);
	    GeomFSave(fd, stdout, "stdout");
	}
}

#ifdef AARG

static aaSetBatch () {
	if (aargv[1][1] == 'n')		/* turn on */
		batch = 1;
	else batch = 0;
}

static aaSetPpoint () {	/* set barycentric coords */
	float total;
	total =  bary.x = atof(aargv[1]);
	total += bary.y= atof(aargv[2]);
	total += bary.z = atof(aargv[3]);
	/* normalize to sum = 1 */
	bary.x /= total;
	bary.y /= total;
	bary.z /= total;
	bary.w = 0.0;
}

static aaSetCmap()	{
	sprintf(cmapfile,"%s",aargv[1]);
}

static struct aarg_cmd cmd[] = {
   0,remain,"trigrp","Create tesselation for [2,n,m] triangle group",0,0,0,0,
   0,aaSetBatch,"[-b[atch] %s]","Turn on/off batch mode [off]",0,0,0,0,
   0,aaSetCmap,"[-getcmap %s]","Set name for colormap file [NULL]",0,0,0,0,
   0,aaSetPpoint,"[-p[oint] %f %f %f]","Set distinguished point [1 1 1](barycentric coordinates)",0,0,0,0,
   AA_STDCMD, AA_LASTCMD
};


	/* If we're using aarg, here's the *real* main program. */

#undef main
main(argc, argv)
char **argv;
{	
    aa_prompt = "trigrp> ";
    aa_main( cmd, argc, argv );

}
#endif /*AARG*/

initmouse()
{
    WnWindow *w;

    qdevice(LEFTMOUSE);
    qdevice(MIDDLEMOUSE);
    qdevice(MENUBUTTON);
    qdevice(KEYBD);

    mgctxget(MG_WINDOW, &w);
    WnGet(w, WN_CURPOS, &wp);
}

drawframe()
{
    Transform T;

    mgworldbegin();
    TmTranslate(T, -.25, -.4, 0.);
    mgtransform(T);
    Make2nmFD(bary, G_236, eucplist);
    GeomDraw(eucplist);
    mgworldend();
}

/* revive this at a later fdate for saving snapshots 
	if (save)	
	   if (interval > 0 )
	      {
	      if (! (iter_count%interval)) 
		{
		sprintf(newfilename,"%s.%d.cpoly",filestem,iter_count/interval);
		savelink(newfilename);
		}
	      }
	    else (savelink(newfilename));
*/
/*
	      if (qtest())	{
    		dev = qread(&val);
		switch(dev)	{
		    case LEFTMOUSE:
    		      if (dev == LEFTMOUSE)	{
		        if (getbutton(LEFTMOUSE)) {
			    stop = 1 - stop ;
			    fprintf(stderr,"stop = %d\n",stop);
			    }
		        qreset();
		        }
			break;
		    case REDRAW:
			drawframe();
			break;
		    }
		}
*/
static int
initmenu()
{
    int pup;
    long groupmenu;


    pup = defpup("Trigrp %t");
    addtopup(pup, "233 [3]%x0|234 [4]%x1|235 [5]%x2|236 [6]%x3|237 [7]%x4|PrintBary [p]%x5|Autopilot [a]%x6|Quit [Q]%x7");

    return pup;
}

