/* (picked "name" (gx gy gz) (vx vy vz) (x1 y1 z1 x2 y2 z2)) */

#include <stdio.h>
#include "lisp.h"
#include "3d.h"
#include "handleP.h"
#include "ooglutil.h"

void deflittlebox(FILE *fp, float size);
void norm(FILE *fp);

int verbose = 0;

static int
moreargs(Pool *p)
{
   register int c;
   return (c = fnextc(p->inf, 0)) != ')' && c != EOF;
}

LObject *
getstringarg(Pool *p, char **strp, char *ermsg)
{
  LObject *arg = LEvalSexpr(p);

  if(arg->type != LSTRING || (*strp = LSTRINGVAL(arg)) == NULL) {
    if(ermsg) fprintf(stderr, "%s: string expected\n", ermsg);
    FreeLObject(arg);
    return Lnil;
  }
  return arg;
}

int ListLength(LList *l)
{
  int n = 1;

  if (!l) return 0;
  if (! l->car ) return 0;
  while (l->cdr) {
    ++n;
    l = l->cdr;
  }
  return n;
}

handle_pick(FILE *fp, int picked, Point3 *got,
	    int vert, Point3 *v, int edge, Point3 e[])
{
  static int first = 1;
  
  if (!picked) {
    fprintf(fp,"(geometry \"pick\" { LIST } )\n");
  } else {
    fprintf(fp,"(geometry \"pick\"\n");
    if (vert) fprintf(fp, "{ appearance { material { diffuse 1 0 1 } }\n");
    else fprintf(fp, "{ appearance { material { diffuse 1 1 0 } }\n");
    fprintf(fp, "  { LIST\n\
    { INST\n\
      transform 1 0 0 0 0 1 0 0 0 0 1 0 %f %f %f 1\n\
      geom :littlebox }\n", got->x, got->y, got->z);
  if (edge && !vert) {
    fprintf(fp,"{ appearance { material { diffuse 0 1 1 } }\n\
  LIST\n\
   { INST\n\
    transform 1 0 0 0 0 1 0 0 0 0 1 0 %f %f %f 1\n\
    geom :littlebox }\n\
      { INST\n\
	transform 1 0 0 0 0 1 0 0 0 0 1 0 %f %f %f 1\n\
	geom :littlebox }\n\
	  { VECT\n\
	  1 2 1\n\
	  2\n\
	  1\n\
	  %f %f %f\n\
	  %f %f %f\n\
	  1 1 0 1\n\
	  } }\n",
	     e[0].x, e[0].y, e[0].z,
	     e[1].x, e[1].y, e[1].z,
	     e[0].x, e[0].y, e[0].z,
	     e[1].x, e[1].y, e[1].z);
    }
    fprintf(fp,"    }\n  }\n)\n");
  }
  if (first) {
    fprintf(fp, "(pickable \"pick\" no)\n");
    first = 0;
  }
  fflush(fp);
}

LObject *Lpicked(Pool *p)
{
  LObject *arg;
  char *name;
  Point3 got,v,e[2];
  int count, vert, edge, picked;
  
  if (! moreargs(p) ) {
    picked = 0;
  } else {
    picked = 1;
    getstringarg(p, &name, "picked: name");
    arg = LSexpr(p);
    if (arg->type != LLIST) {
      fprintf(stderr, "ERROR: picked: list expected (got)\n");
      return;
    }
    if ( (count=ListLength(LLISTVAL(arg))) != 3 ) {
      fprintf(stderr, "ERROR: picked: list of length 3 expected (got)\n");
      return;
    }
    got.x = atof( LSTRINGVAL(LLISTVAL(arg)->car) );
    got.y = atof( LSTRINGVAL(LLISTVAL(arg)->cdr->car) );
    got.z = atof( LSTRINGVAL(LLISTVAL(arg)->cdr->cdr->car) );
    
    arg = LSexpr(p);
    if (arg->type != LLIST) {
      fprintf(stderr, "ERROR: picked: list expected (v)\n");
      return;
    }
    count=ListLength(LLISTVAL(arg));
    vert = 0;
    switch (count) {
    case 0:
      break;
    case 3:
      vert = 1;
      v.x = atof( LSTRINGVAL(LLISTVAL(arg)->car) );
      v.y = atof( LSTRINGVAL(LLISTVAL(arg)->cdr->car) );
      v.z = atof( LSTRINGVAL(LLISTVAL(arg)->cdr->cdr->car) );
      break;
    default:
      fprintf(stderr, "ERROR: picked: list of length 3 expected (v)\n");
      break;
    }
    
    
    arg = LSexpr(p);
    if (arg->type != LLIST) {
      fprintf(stderr, "ERROR: picked: list expected (e1 e2)\n");
      return;
    }
    count=ListLength(LLISTVAL(arg));
    edge = 0;
    switch (count) {
    case 0:
      break;
    case 6:
      edge = 1;
      e[0].x = atof( LSTRINGVAL(LLISTVAL(arg)->car) );
      e[0].y = atof( LSTRINGVAL(LLISTVAL(arg)->cdr->car) );
      e[0].z = atof( LSTRINGVAL(LLISTVAL(arg)->cdr->cdr->car) );
      e[1].x = atof( LSTRINGVAL(LLISTVAL(arg)->cdr->cdr->cdr->car) );
      e[1].y = atof( LSTRINGVAL(LLISTVAL(arg)->cdr->cdr->cdr->cdr->car) );
      e[1].z = atof( LSTRINGVAL(LLISTVAL(arg)->cdr->cdr->cdr->cdr->cdr->car) );
      break;
    default:
      fprintf(stderr, "ERROR: picked: list of length 3 expected (v)\n");
      break;
    }
  }
  
  handle_pick(stdout, picked, &got, vert, &v, edge, e);
  if (verbose)
    handle_pick(stderr, picked, &got, vert, &v, edge, e);
}

init()
{
  LInit();
  LDefun("picked",		Lpicked);
}

HandleOps MyOps = {
	"jibberish",
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
};

pickability(FILE *fp)
{
  fprintf(fp, "(pick yes)\n");
  fflush(fp);
}

main()
{
  Pool *p;
  extern char *getenv();

  verbose = (getenv("VERBOSE_NOSE") != NULL);

  init();
  deflittlebox(stdout, 0.04);
  if (verbose) deflittlebox(stderr, 0.04);

  pickability(stdout);
  if (verbose) pickability(stderr);

  norm(stdout);
  if (verbose) norm(stderr);

  p = PoolStreamTemp("standard input", stdin, 0, &MyOps);
  while (!feof(stdin)) {
    LEvalSexpr(p);
  }
}

void
norm(FILE *fp)
{
  fprintf(fp, "(geometry \"pick\" { LIST } )\n");
  fprintf(fp, "(normalization \"pick\" none)\n");
  fflush(fp);
}



void
deflittlebox(FILE *fp, float size)
{
  fprintf(fp,"\
(read geometry { define littlebox {\n\
	INST\n\
	  transform %f 0 0 0\n\
		    0 %f 0 0\n\
		    0 0 %f 0\n\
		    0 0 0  1\n\
	  geom\n\
	  OFF\n\
	  8 6 12\n\
\n\
	  -.5 -.5 -.5	# 0   \n\
	   .5 -.5 -.5	# 1   \n\
	   .5  .5 -.5	# 2   \n\
	  -.5  .5 -.5	# 3   \n\
	  -.5 -.5  .5	# 4   \n\
	   .5 -.5  .5	# 5   \n\
	   .5  .5  .5	# 6   \n\
	  -.5  .5  .5	# 7   \n\
\n\
	  4 0 1 2 3\n\
	  4 4 5 6 7\n\
	  4 2 3 7 6\n\
	  4 0 1 5 4\n\
	  4 0 4 7 3\n\
	  4 1 2 6 5\n\
	  }})\n", size, size, size);
}
