#include <stdio.h>
#include <math.h>
#include "3d.h"
#include "lang.h"
#include "handleP.h"
#include "ooglutil.h"
#include "graffiti.h"
#include "gui.h"

static Pool *inpool;

static int
moreargs(Pool *p)
{
   return fnextc(p->inf, 0) != ')';
}

LObject *
getstringarg(Pool *p, char **strp, char *ermsg)
{
  LObject *arg = LEvalSexpr(p);

  if(arg->type != LSTRING || (*strp = LSTRINGVAL(arg)) == NULL) {
    if(ermsg) fprintf(stderr, "%s: string expected\n", ermsg);
    FreeLObject(arg);
    return Lnil;
  }
  return arg;
}

int ListLength(LList *l)
{
  int n = 1;

  if (!l) return 0;
  if (! l->car ) return 0;
  while (l->cdr) {
    ++n;
    l = l->cdr;
  }
  return n;
}


handle_pick(char *name, Point3 *got,
	    int vert, Point3 *v, int edge, Point3 e[])
{
  if (inpline) {
    if (name) {
      if (onlyverts) {
	if (vert) {
	  AddVert(v);
	  Geometry();
	}
      } else {
	AddVert(got);
	Geometry();
      }
    }
  }
}

LObject *Lpicked(Pool *p)
{
  LObject *arg;
  char *name = NULL;
  Point3 got,v,e[2];
  int count, vert, edge, picked;
  
  if (! moreargs(p) ) {
    picked = 0;
  } else {
    picked = 1;
    getstringarg(p, &name, "picked: name");
    arg = LSexpr(p);
    if (arg->type != LLIST) {
      fprintf(stderr, "ERROR: picked: list expected (got)\n");
      return;
    }
    if ( (count=ListLength(LLISTVAL(arg))) != 3 ) {
      fprintf(stderr, "ERROR: picked: list of length 3 expected (got)\n");
      return;
    }
    got.x = atof( LSTRINGVAL(LLISTVAL(arg)->car) );
    got.y = atof( LSTRINGVAL(LLISTVAL(arg)->cdr->car) );
    got.z = atof( LSTRINGVAL(LLISTVAL(arg)->cdr->cdr->car) );
    
    arg = LSexpr(p);
    if (arg->type != LLIST) {
      fprintf(stderr, "ERROR: picked: list expected (v)\n");
      return;
    }
    count=ListLength(LLISTVAL(arg));
    vert = 0;
    switch (count) {
    case 0:
      break;
    case 3:
      vert = 1;
      v.x = atof( LSTRINGVAL(LLISTVAL(arg)->car) );
      v.y = atof( LSTRINGVAL(LLISTVAL(arg)->cdr->car) );
      v.z = atof( LSTRINGVAL(LLISTVAL(arg)->cdr->cdr->car) );
      break;
    default:
      fprintf(stderr, "ERROR: picked: list of length 3 expected (v)\n");
      break;
    }
    
    
    arg = LSexpr(p);
    if (arg->type != LLIST) {
      fprintf(stderr, "ERROR: picked: list expected (e1 e2)\n");
      return;
    }
    count=ListLength(LLISTVAL(arg));
    edge = 0;
    switch (count) {
    case 0:
      break;
    case 6:
      edge = 1;
      e[0].x = atof( LSTRINGVAL(LLISTVAL(arg)->car) );
      e[0].y = atof( LSTRINGVAL(LLISTVAL(arg)->cdr->car) );
      e[0].z = atof( LSTRINGVAL(LLISTVAL(arg)->cdr->cdr->car) );
      e[1].x = atof( LSTRINGVAL(LLISTVAL(arg)->cdr->cdr->cdr->car) );
      e[1].y = atof( LSTRINGVAL(LLISTVAL(arg)->cdr->cdr->cdr->cdr->car) );
      e[1].z = atof( LSTRINGVAL(LLISTVAL(arg)->cdr->cdr->cdr->cdr->cdr->car) );
      break;
    default:
      fprintf(stderr, "ERROR: picked: list of length 3 expected (v)\n");
      break;
    }
  }
  
  handle_pick(name, &got, vert, &v, edge, e);
}

HandleOps MyOps = {
	"jibberish",
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
};

LangInit()
{
  inpool = PoolStreamTemp("standard input", stdin, 0, &MyOps);

  LInit();
  LDefun("picked",		Lpicked);
}


void
Input()
{
  LEvalSexpr(inpool);
}
