#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <math.h>
#include "ooglutil.h"
#include "3d.h"
#include "forms.h"
#include "panel.h"
#include "graffiti.h"
#include "gui.h"
#include "guiPt.h"

int inpline = 0;

gui_init()
{
  foreground();
  create_the_forms();
  fl_show_form(MainForm, FL_PLACE_SIZE, TRUE, "Graffiti");
}

gui_main_loop()
{
  int fdmask;
  static struct timeval timeout = {0, 200000};

  while (1) {

    fdmask = 1 << fileno(stdin);
    select(fileno(stdin)+1, &fdmask, NULL, NULL, &timeout);

    if (async_fnextc(stdin,0) != NODATA) {
      Input();
    }
    fl_check_forms();
  }
}

void QuitProc(FL_OBJECT *obj, long val)
{
  exit(0);
}

void UndoButtonProc(FL_OBJECT *obj, long val)
{
  RemoveVert();
  Geometry();
}

void StartButtonProc(FL_OBJECT *obj, long val)
{
  NewPline();
  inpline = 1;
}

void VertexButtonProc(FL_OBJECT *obj, long val)
{
  onlyverts = fl_get_button(obj);
}

void EndClosedButtonProc(FL_OBJECT *obj, long val)
{
  ClosePline();
  Geometry();
  inpline = 0;
}

void EndOpenButtonProc(FL_OBJECT *obj, long val)
{
  inpline = 0;
}
