#include <stdio.h>
#include <math.h>
#include "geom.h"
#include "vect.h"
#include "color.h"
#include "graffiti.h"
#include "gui.h"

FILE *fp;

#define MAXPLINES 100
#define MAXVERTS 1000

int nplines = 0;
short vcounts[MAXPLINES];
short ccounts[MAXPLINES];
int nverts = 0;
Point3 verts[MAXVERTS];

int onlyverts = 0;

FILE *fp;

main(int argc, char *argv[])
{
  Initialize();
  gui_init();
  gui_main_loop();
}

Initialize()
{
  fp = stdout;
  LangInit();
  fprintf(fp, "(pick yes)\n");
  fflush(fp);
}


Geometry()
{
  Geom *g;
  static int unnormalized = 0;

/*
       CR_NVECT,	# polylines
       CR_VECTC,	# verts in each polyline; array of NVECT shorts
       CR_COLRC,	# colors in each polyline; array of NVECT shorts
       CR_NVERT,	total # vertices
       CR_POINT,	the vertices
       CR_NCOLR,	total # colors
       CR_COLOR,	the colors
*/

  g = GeomCreate("vect",
		 CR_NVECT,	nplines,
		 CR_VECTC,	vcounts,
		 CR_NVERT,	nverts,
		 CR_POINT,	verts,

		 CR_NCOLR,	0,
		 CR_COLRC,	ccounts,
		 CR_COLOR,	NULL,

		 CR_END);
  fprintf(fp, "(geometry \"vect\" { ");
  GeomFSave(g, fp, "graffiti output pipe");
  GeomDelete(g);
  fprintf(fp, " } )\n");
  if (! unnormalized) {
    fprintf(fp, "(normalization \"vect\" none)\n");
    unnormalized = 1;
  }
  fflush(fp);
}

NewPline()
{
  if (nplines < MAXPLINES) {
    vcounts[nplines] = 0;
    ccounts[nplines] = 0;
    ++nplines;
  }
}

ClosePline()
{
  vcounts[nplines-1] *= -1;
}

AddVert(Point3 *p)
{
  if (nplines == 0) NewPline();
  if (nverts < MAXVERTS) {
    verts[nverts] = *p;
    ++nverts;
    ++vcounts[nplines-1];
  }
}

RemoveVert()
{
  if (vcounts[nplines-1]>0) {
    --vcounts[nplines-1];
    if (nverts>0) --nverts;
  }
}
