/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Stuart Levy, Tamara Munzner, Mark Phillips */

#include "mg.h"
#include "../common/main.h"
#include "../common/drawer.h"
#include "../common/comm.h"
#include <gl/gl.h>
#include <gl/get.h>
#include <gl/device.h>

Color initial_defaultbackcolor = {.33, .33, .33 };

static char *pipedir = "/tmp/geomview";

static int nwins = 1;

static void usage();
static void parse_args(int argc, char *argv[]);

extern HandleOps CommandOps, GeomOps;

main(int argc, char *argv[])
{
  int i;

  mgdevice_GL();
  foreground();

  init_geomview( 0 );

  parse_args(argc, argv);		/* Load command & data file(s) */

  for(i = 0; i < nwins; i++)
    if (!dview[i]) drawer_new_camera(NULL,NULL,NULL);

  ui_final_init();

  MainLoop();
  return 0;
}

#define STREQ(s1,s2) (strcmp(s1,s2)==0)

static char *me;

static void
parse_args(int argc, char *argv[])
{
  register char **av;
  register int ac;

  me = *argv; 
  for(ac = argc, av = argv+1; --ac > 0; av++) {
    if (STREQ(*av,"-b") && (ac-=3) >= 0) {
      initial_defaultbackcolor.r = atof(*++av);
      initial_defaultbackcolor.g = atof(*++av);
      initial_defaultbackcolor.b = atof(*++av);
    }
    else if(STREQ(*av, "-wins") && --ac >= 0) {
      nwins = atoi(*++av);
    }
    else if(STREQ(*av, "-wpos") && --ac >= 0) {
	WnWindow *win = WnCreate(WN_ENLARGE, 1, WN_SHRINK, 1, WN_END);
	WnPosition wp;
	int a1,a2,a3,a4;
	char ch;

	switch(sscanf(*++av, "%d%*c%d%c%d%*c%d", &a1,&a2,&ch,&a3,&a4)) {
	case 2:
	    WnSet(win, WN_XSIZE, a1, WN_YSIZE, a2, WN_END);
	    break;
	case 1:
	    wp.xmin = a1;
	    if((ac -= 3) < 0) usage();
	    wp.ymin = atoi(*++av);
	    wp.xmax = wp.xmin + atoi(*++av)-1;
	    wp.ymax = wp.ymin + atoi(*++av)-1;
	    break;
	case 5:
	    if(ch == '@') {	/* xsize,ysize@xmin,ymin */
		wp.xmin = a3; wp.xmax = a3 + a1-1;
		wp.ymin = a4; wp.ymax = a4 + a2-1;
	    } else {		/* xmin,ymin,xsize,ysize */
		wp.xmin = a1; wp.ymin = a2; wp.xmax = a1+a3-1; wp.ymax = a2+a4-1;
	    }
	    WnSet(win, WN_PREFPOS, &wp, WN_END);
	    break;
	default:
	    if(!STREQ(*av, "-")) usage();
	    /* "-" => interactive positioning -- fall through */
	}
	drawer_window(DEFAULTCAMID, win);
    } else if(STREQ(*av, "-c") && --ac >= 0) {
	/* Process command file (or string) */
	comm_object( *++av, &CommandOps, NULL, NULL, COMM_LATER );
    } else if(!strncmp(*av, "-M", 2) && --ac >= 0) {
	if(av[0][2])
	    pipedir = &av[0][2];
	usepipe(pipedir, *++av, &GeomOps);
    } else if(av[0][0] == '-' && av[0][1] != '\0') {
	usage();
    } else {
	loadfile(*av, &GeomOps);
    }
  }
}

static void
usage()
{
  fprintf(stderr, "\
Usage: %s [ -b r g b ] [-c commandfile] [ -wins #windows ]\n\
	[-wpos width,height[@xmin,ymin]] [-wpos -] [-M stuff-symbol]\n\
	[ file ... ]\n", me);
  exit(-1);
}

void
hfly_display_draw(DView *dv, float roll, float pitch, float speed)
{
  static float white[4] = {1.0, 1.0, 1.0, 1.0};
  static float black[4] = {0.0, 0.0, 0.0, 1.0};
  char buf[20];

  mmode(MPROJECTION);
  ortho2(0.0, (Coord)(drawerstate.winpos.xmax - drawerstate.winpos.xmin),
	 0.0, (Coord)(drawerstate.winpos.ymax - drawerstate.winpos.ymin));
  mmode(MVIEWING);
  pushmatrix();
  loadmatrix( TM_IDENTITY );

  lmbind( LMODEL, 0 );
  zbuffer( FALSE );
  c4f(white);
  rectfi( 10, 10, 70, 30 );
  c4f(black);
  cmov2i( 15, 15 );
  sprintf(buf, "%.3f", speed);
  charstr(buf);
  zbuffer( TRUE );

  popmatrix();
}

/*
 * isntsc() -- returns 1 if NTSC mode enabled, else 0.
 */
int
isntsc()
{  return getmonitor() == NTSC; }

/*
 * ntsc() -- turns NTSC mode on (1) or off (0), or toggle (-1).
 */
ntsc(int on)
{
    if(on < 0)		/* Toggle */
	on = !isntsc();

    setmonitor(on ? NTSC : HZ60);
    setvideo(GL_VIDEO_REG, getvideo(GL_VIDEO_REG) | GLV_SGREEN);
}
