/*
 * newthor.c: This program essentially parses the description of generators for
 * 		a space group given in "230data".
 *
 * Routines:  thor (and its subjects) formparse and lateparse
 *
 * 30 May 1990, by Olaf Holt
 */

#include <stdio.h>
#include <string.h>
#include <math.h>
#include "ooglutil.h"
#include "linalg.h"
#include "forms.h"
#include "geom.h"

#define PRINTMAT(a) \
{fprintf(stderr,"\t(%3.3f %3.3f %3.3f %3.3f)\n",a[0][0],a[1][0],a[2][0],a[3][0]);  \
   fprintf(stderr,"\t(%3.3f %3.3f %3.3f %3.3f)\n",a[0][1],a[1][1],a[2][1],a[3][1]);  \
     fprintf(stderr,"\t(%3.3f %3.3f %3.3f %3.3f)\n",a[0][2],a[1][2],a[2][2],a[3][2]);  \
       fprintf(stderr,"\t(%3.3f %3.3f %3.3f %3.3f)\n",a[0][3],a[1][3],a[2][3],a[3][3]);  }
#define PRINT	3

struct table{ char *keyword; int keysymbol; };
int	lattype = 0;

extern short VERBOSEFLAG;

/*
 *  Function:   formparse
 *  Description:       changes a description of a linear transformation
 *  		from alphanumeric representation  to a 4 x 4 matrix. 
 *  Args IN:    string:  the alphanumeric representation  (e.g. x-yXz)
 * 				matrix:  the resulting matrix
 *  Returns:  nothing
 */
formparse(string,matrix)
     char *string;
     float matrix[][4];
{
  int ii,kk,index = 0;
  static struct table formtypes[8] = { {"x",1},{"y",2},{"z",3},{"X",4},
					 {"Y",5},{"Z",6},{"+",7},{"-",8} };
  
  while (string[0] != 0 && string[0] != '\n') {
    for(kk=0; kk<=7; kk++)
      if(string[0] == formtypes[kk].keyword[0])
	ii = formtypes[kk].keysymbol;
    switch (ii) {
    case 1:
      matrix[index][0] = 1; matrix[index][1] = matrix[index][2] = 0;
      index++; break;
    case 2:
      matrix[index][1] = 1; matrix[index][0] = matrix[index][2] = 0;
      index++; break;
    case 3:
      matrix[index][2] = 1; matrix[index][0] = matrix[index][1] = 0;
      index++; break;
    case 4:
      matrix[index][0] = -1; matrix[index][1] = matrix[index][2] = 0;
      index++; break;
    case 5:
      matrix[index][1] = -1; matrix[index][0] = matrix[index][2] = 0;
      index++; break;
    case 6:
      matrix[index][2] = -1; matrix[index][0] = matrix[index][1] = 0;
      index++; break;
    case 7:
      string++; 
      if(string[0] == 'x') (matrix[--index][0])++;
      else if(string[0] == 'y') (matrix[index][1])++;
      else if(string[0] == 'z') (matrix[index][2])++;
      index++; break;
    case 8:
      string++; 
      if(string[0] == 'x') (matrix[--index][0])--;
      else if(string[0] == 'y') (matrix[index][1])--;
      else if(string[0] == 'z') (matrix[index][2])--;
      index++; break;
    default:
      fprintf(stderr,"default encountered in parsing formstring\n");
    }
    string++;}
  if(index != 3) fprintf(stderr,"230data parse error\n");
}

/*
 *  Function:   lateparse
 *  Description:       adds a description of a translation
 *  		in alphanumeric notation  to a 4 x 4 matrix. 
 *  Args IN:    string:  the alphanumeric representation  (e.g. i+j)
 * 				matrix:  the operative matrix
 *  Returns:  nothing
 */
lateparse(string,matrix)
     char *string;
     float matrix[][4];
{
  int ii,jj = 0,kk;
  float sign = 1;
  static struct table latetypes[10] = { {"i",1},{"j",2},{"k",3},{".",4},
					  {"2",5},{"3",6},{"5",7},{"6",8},{"+",9},{"-",10} };
  
  matrix[0][3] = 0;
  matrix[1][3] = 0;
  matrix[2][3] = 0;
  matrix[3][3] = 1;
  
  while (string[0] != 0 && string[0] != '\n') {
  JUMP: for(kk=0; kk<=9; kk++)
    if(string[0] == latetypes[kk].keyword[0])
      ii = latetypes[kk].keysymbol;
    switch (ii) {
    case 1:
      jj += 1;  break;
    case 2:
      jj += 2;  break;
    case 3:
      jj += 3;  break;
    case 4:
      jj += 6;  string++; goto JUMP;
    case 5:
      jj += 3;  string++; goto JUMP;
    case 6:
      jj += 1;  string++; goto JUMP;
    case 7:
      string++; goto JUMP;
    case 8:
      jj += 2;  string++; goto JUMP;
    case 9:
      sign = 1;  jj = 0; string++; goto JUMP;
    case 10:
      sign = -1;  jj = 0; string++; goto JUMP;
    default:
      fprintf(stderr,"error encountered in lateparse of 230\n");
    }
    switch (jj) {
    case 1:
      matrix[0][3] += 0.5*sign; break;
    case 2:
      matrix[1][3] += 0.5*sign; break;
    case 3:
      matrix[2][3] += 0.5*sign; break;
    case 4:
      matrix[0][3] += sign; break;
    case 5:
      matrix[1][3] += sign; break;
    case 6:
      matrix[2][3] += sign; break;
    case 7:
      matrix[0][3] += 0.25*sign; break;
    case 8:
      matrix[1][3] += 0.25*sign; break;
    case 9:
      matrix[2][3] += 0.25*sign; break;
    case 10:
      matrix[2][3] += sign/6; break;
    case 11:
      matrix[2][3] += sign/3; break;
    default:
      fprintf(stderr,"error in part 2, lateparse\n");
    }
    string++;
  }
}

/*
 *  Function:   thor
 *  Description:    generates the group elements needed by mantis, for 
 * 		a given group.    
 *  Args IN:    grpnum:  the number of the group, from 1 to 230.
 * 
 *  the correspondence of this number with names in the file "230data.names"
 *
 *  thegroup:	the array where particular group elements are placed
 *    as 4 x 4 matrices.  The choice of which to use
 *    is sometimes arbitrary but roughly corresponds
 *    to those which don't move the "cell" the length
 *    of a primitive translation.
 *  thetrans:	the array where primitive translations and their
 *    inverses are placed.
 *
 *  Returns:  the number of group elements "in a cell"
 */
thor(grpnum,thegroup,thetrans,maxtmat)
     int grpnum;
     float thegroup[][4][4], thetrans[][4][4];
     int *maxtmat;
{
  char keyword[20],groupsymbols[256],*parse[15],*nic,*ollett;
  char path[80];
  int i,j,k,ujsag,numsym=0,power = 0;
  int fir[3],i1,i2,i3,i4,i5,par[6];
  int ipvt,info,job = 01,three = 4;
  float rcond,z,work[4],det[2];
  float v1[3],m1[4][4],m2[4][4],m3[4][4],fi,se,th,fum;
  static struct table bravais[15] = { {"tr",1},{"m",2},{"m'",3},{"o",4},{"o'",5}, {"o''",6},{"o'''",7},{"t",8},{"t'",9},{"c",10},{"c'",11}, {"c''",12},{"rh",13},{"h",14},{NULL,0} };
  float generator[10][4][4];
  FILE *f;
  Transform tmp;
  
  if(VERBOSEFLAG) {
    fprintf(stderr,"\nGROUP #%d\n",grpnum);
  }
  
  sprintf(path, "%s", findfile(NULL,"230data"));
  if((f = fopen(path,"r")) == NULL)
    {fprintf(stderr,"Can't open file 230data!\n"); 
     fprintf(f, "(ui-extern-done )\n");
     exit(0); }

  for(i=1; i<=grpnum; i++) 
    fgets(groupsymbols,sizeof(groupsymbols),f);
  fclose(f);
  
  /* groupsymbols is of form "xxx. (lattice type) (generator) (generator)..." */
  
  parse[0] = strtok(groupsymbols," 	/n"); i=0;
  while ((parse[++i]=strtok(NULL," 	/n")) != NULL) ;
  
  for(k=0; k<=13; k++)
    if(strcmp(parse[1],bravais[k].keyword) == 0)
      lattype = bravais[k].keysymbol;
  
  ouax(PRINT);  /*  send a message about what lattice is used here  */
  /* and how it can be modified  */
  
  
  /*  now parse the information from the file regarding group generators  */
  for(j=2; j<i; j++)
    if(strchr(parse[j],',') != NULL) {
      nic = strtok(parse[j],",");
      lateparse(nic,generator[j-2]);
      ollett = strtok(NULL,",");
      VECEQUAL4(generator[j-2][3],LASTROW);
      formparse(ollett,generator[j-2]);		
    } else {
      VECEQUAL4(generator[j-2][3],LASTROW);
      generator[j-2][0][3] = 0;
      generator[j-2][1][3] = 0;
      generator[j-2][2][3] = 0;
      formparse(parse[j],generator[j-2]);		
    }
  
  /*  this gets descriptions of the primitive translations   */

  sprintf(path, "%s", findfile(NULL,"230data.lat"));
  if((f = fopen(path,"r")) == NULL)
    {fprintf(stderr,"Can't open file 230data.lat!\n"); 
     fprintf(f, "(ui-extern-done )\n");
     exit(0); }
  
  for(j=1; j<=lattype; j++)
    fgets(groupsymbols,sizeof(groupsymbols),f);
  
  fclose(f);
  /* groupsymbols is now of form "xxx. (translation) (translation)..." */
  for(j=0; j<15; j++) parse[j] = NULL;
  parse[0] = strtok(groupsymbols," 	/n"); k=0;
  while ((parse[++k]=strtok(NULL," 	/n")) != NULL) ;
  
  for(j=i-2; j<i+k-3; j++) {
    MATEQUAL3(generator[j],IDENTITYMATRIX3);
    VECEQUAL4(generator[j][3],LASTROW);
    lateparse(parse[j-i+3],generator[j]);
    MATEQUAL4(thetrans[j-i+2],generator[j]);
    MATEQUAL4(thetrans[j-i+6],generator[j]);
  }
  if ( k == 4 ) MATEQUAL4(thetrans[3],IDENTITYMATRIX4);
  
  /*  make the inverse translations, too   */
  for(j=4; j<8; j++) {
    TmInvert(thetrans[j], tmp);
    TmCopy(tmp, thetrans[j]);
  }
  
  /*  I don't know why sgedi doesn't work on thetrans[3]  */
  if ( k == 4 )  MATEQUAL4(thetrans[7],IDENTITYMATRIX4);
  
  /*   this routine registers the order of the linear part of each generator  */
  for(j=0;j<6;j++)	par[j] = 0;
  for(i1 = 0; i1<i-2; i1++) {
    MATEQUAL3(m1,generator[i1]);
    MATEQUAL3(m2,m1);
    while( ISIDENTITY3(m2) != 1 ) {
      MATXMAT3(m1,m2,m3);
      MATEQUAL3(m2,m3);
      power++;
    }
    if((par[i1] = power) == 0) 
      if(VERBOSEFLAG)
	fprintf(stderr,"Found identity matrix!!\n");
    power = 0;
  }
  
  /* now to make all the group elements "in a cell", while keeping them
     "within the cell", that is, removing unwanted translational components.
     */
  for(i5=0; i5<=par[4]; i5++) {
    for(i4=0; i4<=par[3]; i4++) {
      for(i3=0; i3<=par[2]; i3++) {
	for(i2=0; i2<=par[1]; i2++) {
	  for(i1=0; i1<=par[0]; i1++) {
	    MATEQUAL4(m2,IDENTITYMATRIX4);
	    for(j=0;j<i5;j++) {
	      MATXMAT4(generator[4],m2,m1);
	      MATEQUAL4(m2,m1); }
	    for(j=0;j<i4;j++) {
	      MATXMAT4(generator[3],m2,m1);
	      MATEQUAL4(m2,m1); }
	    for(j=0;j<i3;j++) {
	      MATXMAT4(generator[2],m2,m1);
	      MATEQUAL4(m2,m1); }
	    for(j=0;j<i2;j++) {
	      MATXMAT4(generator[1],m2,m1);
	      MATEQUAL4(m2,m1); }
	    for(j=0;j<i1;j++) {
	      MATXMAT4(generator[0],m2,m1);
	      MATEQUAL4(m2,m1); }
	    
	    /*  this part detects and destroys unwanted translational components  */
	    fum = CDET2(thetrans[k-4],thetrans[k-3],thetrans[k-2]);
	    if(fum == 0) { 
	      fprintf(stderr,"fum is zero\n");
	      fprintf(f, "(ui-extern-done )\n");
	      exit(0);
	    }
	    fi = CDET2(m2,thetrans[k-3],thetrans[k-2]);
	    fi /=   fum;
	    se = CDET2(thetrans[k-4],m2,thetrans[k-2]);
	    se /=   fum;
	    th = CDET2(thetrans[k-4],thetrans[k-3],m2);
	    th /=   fum;
	    fir[0] = (int)floor(fi+.1);
	    fir[1] = (int)floor(se+.1);
	    fir[2] = (int)floor(th+.1);
	    for(ujsag=0; ujsag<3; ujsag++) {
	      if(fir[ujsag]>0) {
		for(j= 1; j<=fir[ujsag]; j++) {
		  MATEQUAL4(m1,m2);
		  MATXMAT4(m1,thetrans[k+ujsag],m2);
		}
	      } else if(fir[ujsag]<0) {
		for(j= -1; j>=fir[ujsag]; j--) {
		  MATEQUAL4(m1,m2);
		  MATXMAT4(m1,thetrans[k-4+ujsag],m2);
		}
	      }
	    }
	    MATEQUAL4(thegroup[numsym],m2);
	    if(numsym<255)	numsym++;
	  }}}}}
  
  /*  finally, tell the user a little about this group   */
  if (VERBOSEFLAG) {
    fprintf(stderr,"Other information:\n\t%d cell generators    %d translation generators\n",i-2,k-1);
    fprintf(stderr,"\t%d symmetries per cell.\n",numsym);
  }
  
  /* and return the number of tabled translations, matrices    */
  *maxtmat = k-1;
  return(numsym);
}

