/*
 * linalg.h:  a header file with some useful linear algebra routines
 *
 * Routines:  these are all macros, hence recognizable by caps.
 *
 * July 1990,  by Olaf Holt
 */

#define ROOTTOT sqrt(3.0)/2.0
#define VECEQUAL3(a,b)  {a[0] = b[0]; a[1] = b[1]; a[2] = b[2]; }
#define MATEQUAL3(a,b)  {VECEQUAL3(a[0],b[0]); VECEQUAL3(a[1],b[1]); \
                        VECEQUAL3(a[2],b[2]); }
#define MATXVEC3(a,b,c) {c[0] = a[0][0]*b[0] + a[1][0]*b[1] + a[2][0]*b[2]; \
                        c[1] = a[0][1]*b[0] + a[1][1]*b[1] + a[2][1]*b[2]; \
                        c[2] = a[0][2]*b[0] + a[1][2]*b[1] + a[2][2]*b[2]; }
#define MATXMAT3(a,b,c) {MATXVEC3(a,b[0],c[0]); MATXVEC3(a,b[1],c[1]); \
                        MATXVEC3(a,b[2],c[2]); }
#define DET3(a)   a[0][0]*(a[1][1]*a[2][2]-a[1][2]*a[2][1]) - \
                 a[0][1]*(a[1][0]*a[2][2]-a[1][2]*a[2][0]) + \
                 a[0][2]*(a[1][0]*a[2][1]-a[1][1]*a[2][0])
#define CDET(a,b,c) ( a[0]*(b[1]*c[2]-b[2]*c[1]) - \
                 a[1]*(b[0]*c[2]-b[2]*c[0]) + \
                 a[2]*(b[0]*c[1]-b[1]*c[0]) )
#define CDET2(a,b,c)  (a[0][3]*(b[1][3]*c[2][3] - b[2][3]*c[1][3]) + \
                        a[1][3]*(b[2][3]*c[0][3] - b[0][3]*c[2][3]) + \
                        a[2][3]*(b[0][3]*c[1][3] - b[1][3]*c[0][3]));
#define SMALL   .001
#define ISIDENTITY3(a) ( (fabs(a[0][0]-1) < SMALL) && (fabs(a[1][1]-1) < SMALL)\
                        && (fabs(a[2][2]-1) < SMALL) && (fabs(a[0][1]) < SMALL)\
			            && (fabs(a[0][2]) < SMALL) && (fabs(a[1][0]) < SMALL)\
                        && (fabs(a[1][2]) < SMALL) && (fabs(a[2][0]) < SMALL)\
                        && (fabs(a[2][1]) < SMALL) )
#define VECEQUAL4(a,b)  {a[0] = b[0]; a[1] = b[1]; a[2] = b[2]; a[3] = b[3]; }
#define MATEQUAL4(a,b)  {VECEQUAL4(a[0],b[0]); VECEQUAL4(a[1],b[1]); \
                         VECEQUAL4(a[2],b[2]); VECEQUAL4(a[3],b[3]); }
#define MATXVEC4(a,b,c) {c[0] = a[0][0]*b[0] + a[1][0]*b[1] + a[2][0]*b[2] + a[3][0]*b[3]; \
                         c[1] = a[0][1]*b[0] + a[1][1]*b[1] + a[2][1]*b[2] + a[3][1]*b[3]; \
                        c[2] = a[0][2]*b[0] + a[1][2]*b[1] + a[2][2]*b[2] + a[3][2]*b[3]; \
                        c[3] = a[0][3]*b[0] + a[1][3]*b[1] + a[2][3]*b[2] + a[3][3]*b[3]; }
#define MATXMAT4(a,b,c) {MATXVEC4(a,b[0],c[0]); MATXVEC4(a,b[1],c[1]); \
                        MATXVEC4(a,b[2],c[2]); MATXVEC4(a,b[3],c[3]); }

static float ZEROTRANS[3] = { 0, 0, 0 };
static float LASTROW[4] = { 0, 0, 0, 1 };
static float IDENTITYMATRIX3[3][3] = { {1,0,0}, {0,1,0}, {0,0,1} };
static float IDENTITYMATRIX4[4][4] = { {1,0,0,0}, {0,1,0,0}, {0,0,1,0}, {0,0,0,1} };
