/*
 *  glgcalls.c: sets up the menu of group names
 *
 *  Routines:  setupmenus
 *
 *  July 1990    by Olaf Holt
 */

#include <stdio.h>
#include <device.h>
#include <stdlib.h>
#include "forms.h"
#include "controlpanel.h"
#include "ooglutil.h"

extern void s1_proc(), s2_proc(), s3_proc(), s4_proc(),  t1_proc(), t2_proc(), t3_proc(), m_proc(); 

extern long menuhandle();
extern int whichcell,maxpmat;
extern float cells[][4][4];
extern float rangex, rangey, rangez;
extern int maxwhich;
int boxflag = 1;
extern short ARRAYFLAG;
extern short DDOMDEBUG;
extern short VERBOSEFLAG;
char nameslist[230][21];
char othernames[230][30];
long mainmenu;

static int xorg, yorg, xsize, ysize;
#define XMIN     0.0
#define XMAX    10.0
#define YMIN     0.0
#define YMAX    10.0
#define ESC     27



/*
 *  Function:   setupmenus
 *  Description:        sets up the menu of groupnames
 *  Args IN:    none
 *  Returns:  nothing
 */
setupmenus()
{
  long tricmenu, monomenu, orthomenu, tetramenu;
  long trigmenu, hexamenu, cubicmenu, menu[32];
  long mainmval;
  int n1,n2;
  char buzzoff[941];
  char path[80];
  char *charstar;
  static int menunames[] = { 1,2,7,3,10,38,16,47,89,75,95,113,101,77,123,179,183,191,185,198,209,204,221,219,205,215,227,143,148,161,155,169 };
  static int menunumofgrps[] = {1,1,3,4,6,9,22,28,6,2,6,10,12,12,20,4,2,7,6,6,6,1,6,2,4,4,4,5,7,8,6,10 };
  FILE *f;
  
  
  /*  rather than retype all the names, find them in a file  */
  sprintf(path, "%s", findfile(NULL,"230data.names"));
  if((f=fopen(path,"r"))== NULL) {
    fprintf(stderr,"Can't open file 230data.names!\n");
    fprintf(f, "ui-extern-done\n");
    exit(0);
  }
  for(n1=0; n1<230; n1++) {
    fgets(buzzoff,sizeof(buzzoff),f);
    sscanf(buzzoff,"%d. %s",&n2,nameslist[n1]);
  }
  fclose(f);
  
  
  /*  Now get the Conway notation   */
  for(n1=0; n1 < 230; n1++)
    othernames[n1][0] = NULL;
  sprintf(path, "%s", findfile(NULL,"230data.Conway"));
  if((f=fopen(path,"r")) == NULL) {
    fprintf(stderr,"Can't open 230data.Conway!\n");
  } else {
  for(n1=0; n1<230; n1++) {
    fgets(buzzoff,sizeof(buzzoff),f);
    sscanf(buzzoff,"%d. %s",&n2,othernames[n1]);
  }
  fclose(f);
  }

/*  these are the lowest level menus  */
  for(n1=0; n1<32; n1++) {
    sprintf(buzzoff,"space group%%t%%F|");
    charstar = buzzoff + strlen(buzzoff);
    for(n2=menunames[n1];n2<menunames[n1] + menunumofgrps[n1];n2++) {

		if(othernames[n2-1][1] == 'n')  /*  if "no fibration"  */
        	sprintf(charstar,"%s %%x%d|",nameslist[n2-1],n2);
		else
        	sprintf(charstar,"%s or %s %%x%d|",nameslist[n2-1],othernames[n2-1],n2);

        charstar += strlen(charstar);
    }
    charstar[-1] = 0;
    menu[n1] = defpup(buzzoff,menuhandle);
  }

/*  these are the second level menus   */
  tricmenu = defpup("point group%t|1 %m|1 %m",menu[0],menu[1]);
  monomenu = defpup("point group%t|2 %m|m %m|2/m %m",menu[2],menu[3],menu[4]);
  orthomenu = defpup("point group%t|222 %m|2mm %m|2/m2/m2/m %m",menu[5],menu[6],menu[7]);
  tetramenu = defpup("point group%t|4 %m|^4 %m|4/m %m|422 %m|4mm %m|^42m %m|4/m2/m2/m %m",menu[8],menu[9],menu[10],menu[11],menu[12],menu[13],menu[14]);
  trigmenu = defpup("point group%t|3 %m|^3 %m|32 %m|3m %m|^32/m %m",menu[15],menu[16],menu[17],menu[18],menu[19]);
  hexamenu = defpup("point group%t|6 %m|^6 %m|622 %m|6/m %m|^62m %m|6mm %m|6/m2/m2/m %m",menu[20],menu[21],menu[22],menu[23],menu[24],menu[25],menu[26]);
  cubicmenu = defpup("point group%t|23 %m|2/m^3 %m|432 %m|^43m %m|4/m^32/m %m",menu[27],menu[28],menu[29],menu[30],menu[31]);

/*  this is the top-level menu   */
  mainmenu = defpup("System %t|Triclinic %m|Monoclinic %m|Orthorhombic %m|Tetragonal %m|Trigonal %m|Hexagonal %m|Cubic %m|Exit Menu",tricmenu, monomenu, orthomenu, tetramenu, trigmenu, hexamenu, cubicmenu);
}
