/*
 *   filecalls.c:  mostly contains routines for finding and writing files
 *
 *	Routines:  printmats
 *
 *	July 30, 1990     by Olaf Holt
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "linalg.h"
#include "forms.h"
#include "geom.h"

extern char *strtok();
extern char *getenv();
extern int whichcell;
extern float cells[][4][4];
extern float thegroup[][4][4];
extern Transform zszhrp,ZSZHRP;   
extern short VERBOSEFLAG;

/*
 *  Function:   printmat  (originally called printmats)
 *  Description:  prints current group element matrices to a file
 *  Args IN:   t1string:  name of current group
 *			   t2string:  number of elements per cell
 *			   outfile:   name of file to save it in
 *  Returns: nothing
 */
printmat(t1string,t2string,outfile)
char *t1string, *t2string, *outfile;
{
    FILE *f;
	char messagestring[80];
    float generic[4][4], generic1[4][4];
    static int i, j, k, t2int, whichout = 0;

    if((f = fopen(outfile,"w")) == NULL ) {
		fl_show_message("Couldn't open that file!","","");
		return(0);
    }
  whichout++;
    sscanf(t2string,"%d",&t2int);
    for( i = 0; i< whichcell; i++)
        for( j = 0; j< t2int; j++) {
            MATXMAT4(ZSZHRP,thegroup[j],generic);
            MATXMAT4(generic,cells[i],generic1);
            MATXMAT4(generic1,zszhrp,generic);
            for(k = 0; k<4; k++)
                fprintf(f,"%f %f %f %f\n",generic[0][k],generic[1][k],generic[2][k],generic[3][k]);
            fprintf(f,"\n");
        }
    fclose(f);
	sprintf(messagestring,"Output symmetries to ""%s.""",outfile);
	writemessage(messagestring);
}
