/*
 *	eucsyms.c:	Presentation program for 3-d space groups
 *
 *		skeleton: glgdemo.c   interface:  by Mark Overmars' Forms library
 *
 *  Routines:  writemessage, t1_proc, t2_proc, t3_proc, main, menuhandle
 *
 *	version II:  January 14,1992 		by Olaf Holt
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <device.h>
#include <gl.h>
#include "forms.h"
#include "controlpanel.h"
#include "linalg.h"
#include "ooglutil.h"
#include "geom.h"
#include "geomclass.h"
#include "point.h"

#define MAXCELLS	2054      /*   Maximum number of cell replications  */
	/*  NOTE:  also needed in arrays.c and callbacks.c!!! */
#define MAXPOINTS	196		/*  Maximum number of group images per cell  */
#define MAXTRANS	8	/*  Number of accessable (primitive) translations  */

char t1_string[16], t2_string[4], t3_string[50];

extern Geom *obj;

float thegroup[MAXPOINTS][4][4];  /* stores matrix representations of group elements "in a cell"  */
float cells[MAXCELLS][4][4];   /*  translations used in the display   */
float thetrans[MAXTRANS][4][4];  /*  translations used to build above trans.  */

float parama=.2,paramb=0.1,paramc=1.2,params=1,oposx=0.2,oposy=0.1,oposz=0.05;
    /* stores the values of the sliders   */
Transform zszhrp,ZSZHRP,movemat;   /*   matrix to squeeze space as parameters[sabc] require */

int whichcell = 1;   /* whichcell indicates how many translations */
int maxpmat = 1;  /* indicate max number of matrices inside one cell  */
int usedsliders = 3;  /*  indicates how many slider parameters for the group */
int maxwhich = 1;   /* indicates largest number of translations used so far */
extern int boxflag;   /*   whether axes should appear   */
short ARRAYFLAG;   /*  whether array option has been chosen   */
short DDOMFLAG = 0;	  /*  whether displaying a Dirichlet domain   */
short VERBOSEFLAG = 0;  /*  verbose printing mode  */
char	objname[256];   /*  stores the name of the object  */

extern FILE *f;
extern char nameslist[][21];  /*  stores group names (crystallographic) */
extern char othernames[][30];  /*  stores group names (Conway-Thurston) */





/*
 *  Function: writemessage 
 *  Description: puts a message in the grey box in the misc. panel
 *  Args IN:  s, a string containing the message
 *  Returns: nothing
 */
void writemessage(s)
	char *s;
{
			fl_unfreeze_object(messagebox);
			fl_set_input(messagebox,s);
			fl_freeze_object(messagebox);
}


/*
 *  Function: t1_proc
 *  Description:  processes changes in "Groupname" string
 *  Args IN:  none
 *  Returns: nothing
 */
int
  t1_proc()
{
  /*  this procedure gets the new group*/
  int i;
  static char labelstring[40];
  int maxtmat = 3;  /*  indicates the number of translations for the group  */
  
  /*  first find the number corresponding to the name   */
  for(i=1; strcmp(nameslist[i-1],t1_string) && i<231; i++); 
  if (i > 230 ) {
    for(i=1; strcmp(othernames[i-1],t1_string) && i<231; i++); 
    if (i > 230 || t1_string[0] == 'n')  {
      fl_show_message("Unrecognized group name.","","");
      return;
    }
  } 
  
  /*  then get the new group, and update whichcell etc  */
  maxpmat = thor(i,thegroup,thetrans,&maxtmat);
  sprintf(t2_string,"%d",maxpmat);
  t2_proc();
  ouax(0);
  warp();
  
  if( maxtmat == 4 ) {  /* if we use 4 translations */
    sprintf(labelstring,"(%2.2f,%2.2f,%2.2f)",thetrans[3][0][3],thetrans[3][1][3],thetrans[3][2][3]);
    fl_set_object_label(middir,labelstring);
    fl_show_object(middir);
    fl_redraw_object(middir);
    /*			fl_unfreeze_object(middir);
			fl_set_input(middir,labelstring);
			fl_freeze_object(middir);		*/
    fl_show_object(minusmid);
    fl_show_object(plusmid);
  } else {
    fl_hide_object(middir);
    fl_hide_object(minusmid);
    fl_hide_object(plusmid);
  }
  
  switch ( usedsliders ) { /*  controls how many sliders on panel */	
  case 0:
    fl_hide_object(aslider);
    fl_hide_object(bslider);
    fl_hide_object(cslider);
    break;
  case 1:
    fl_hide_object(aslider);
    fl_show_object(bslider);
    fl_hide_object(cslider);
    break;
  case 2:
    fl_show_object(aslider);
    fl_show_object(bslider);
    fl_hide_object(cslider);
    break;
  case 3:
    fl_show_object(aslider);
    fl_show_object(bslider);
    fl_show_object(cslider);
    break;
  }
  
  if (DDOMFLAG) {
    Utterlynewdirdom();
  }
  fl_set_input(groupname,t1_string);
  sprintf(t2_string,"%d",maxpmat);
  fl_set_input(displayingptgrpsyms,t2_string);
  fl_unfreeze_object(totalptgrpsyms);
  fl_set_input(totalptgrpsyms,t2_string);
  fl_freeze_object(totalptgrpsyms);
}

/*
 *  Function: t2_proc
 *  Description:  processes changes in "# of elements" string
 *  Args IN:  none
 *  Returns: nothing
 */
int
  t2_proc()
{
  int t2int;
  int i;
  float new[MAXCELLS][4][4];

  /*  change number of group elements "in a cell"  */
  /*  most of this is oogl manipulations  */
  sscanf(t2_string,"%d",&t2int);
  if(t2int <= maxpmat) {
    fprintf(f, "(read geometry { define thegrouphandle { TLIST\n");
    for (i=0; i<t2int; i++)
      TmTranspose(thegroup[i], new[i]);

    fputtransform(f, t2int, (float *)new, 0);
    fprintf(f, "} } ) \n");
    fflush(f);
  } else {
    sprintf(t2_string,"%d",maxpmat); 
    fl_show_message("Too many group elements!","","");
  }
}

/*
 *  Function: t3_proc
 *  Description:  processes changes in "Objectname" string
 *  Args IN:  none
 *  Returns: nothing
 */
int
  t3_proc()
{
  char path[80];
  /* this is to switch objects */
  
  sprintf(objname,t3_string);
  if((obj = GeomLoad(findfile(NULL, objname))) == NULL)
    fl_show_message("Object could not be loaded.","","");
  else { 
    fprintf(f, "(read geometry { define objhandle \n");
    GeomFSave(obj, f, "");
    fprintf(f, "} )\n");
    fflush(f);
    writemessage("New object installed");
    DDOMFLAG = 0;
  }
}

/*
 *  Function:   main
 *  Description:  parses command line and calls appropriate routines
 *  Args IN:  command line strings
 *  Returns: nothing
 */
main(argc,argv)
     unsigned argc;
     char **argv;
{
  char path[80],syscall[512];
  
  sprintf(t1_string,"p1");
  sprintf(t2_string,"1");
  sprintf(t3_string,"cube2.off");
  sprintf(objname,"cube2.off");
  ARRAYFLAG = 1;
  
  foreground(); 
  create_the_forms();
  fl_set_slider_bounds(aslider, -5.0, 5.0);
  fl_set_slider_value(aslider, 0.2);
  fl_set_slider_bounds(bslider, -5.0, 5.0);
  fl_set_slider_value(bslider, 0.1);
  fl_set_slider_bounds(cslider, -5.0, 5.0);
  fl_set_slider_value(cslider, 1.2);
  fl_set_slider_bounds(objectscalefactor, 0.001, 1.0);
  fl_set_slider_value(objectscalefactor,1.0);
  fl_set_positioner_xbounds(xyposition, -1.0, 1.0);
  fl_set_positioner_xvalue(xyposition, .2);
  fl_set_positioner_ybounds(xyposition, -1.0, 1.0);
  fl_set_positioner_yvalue(xyposition, .1);
  fl_set_dial_bounds(zposition, -0.5, 0.5);
  fl_set_dial_value(zposition, 0.05);
  fl_set_button(axes, 1);
  fl_set_input(latticeposition,"(0,0,0)");
  fl_set_input(displayingcells,"1");
  
  fl_show_form(eucsymscontrolpanel,FL_PLACE_SIZE,TRUE,"Eucsyms");
  fl_freeze_object(latticeposition);
  fl_freeze_object(displayingcells);
  fl_freeze_object(totalptgrpsyms);
  fl_freeze_object(messagebox);
  
/* now eucsyms is an external module of geomview, so don't have
 * any more commandline options 
 */

  ARRAYFLAG = 0;   /* just to make sure!  */
  
  Tooglinit();
  
  qdevice(LEFTMOUSE);
  qdevice(MIDDLEMOUSE);
  qdevice(RIGHTMOUSE);
  qdevice(KEYBD);
  
  setupmenus();
  
  t1_proc();  /*  in case a group was chosen on the command line  */
  
  winpop();
  
  while (1) { fl_do_forms();  }
}

 
/*
 *  Function: menuhandle 
 *  Description: responds when you choose a menu item
 *  Args IN:  n, an integer corresponding with the chosen group.
 *  Returns: nothing
 */
long
  menuhandle(n)
int n;
{
  /*  first put the name in the "groupname" box   */
  sprintf(t1_string,"%s",nameslist[n-1]);
  /*  then get the group   */
  t1_proc();
}
