/*
 *  dirdomcalls.c:   helps with the Dirichlet domain generation
 *
 *						and actually makes the necessary link, Dir_Domain()
 *
 *  Routines:	Dirdomcall, Utterlynewdirdom
 *
 *  Jan 5, 1991		by Olaf Holt
 */

#include "geom.h"
#include "linalg.h"

Transform *sendsyms;  /*  this stores symmetries for DDom option */
extern float oposx, oposy, oposz;
extern int maxpmat;
extern Geom *obj;
extern Transform zszhrp, ZSZHRP;
extern short DDOMFLAG;
extern float thegroup[][4][4], thetrans[][4][4];
/* extern Geom *Dir_Domain(); */
short DDOMDEBUG = 0;  /*   Debugging flag for D. domain program  */

extern FILE *f;

/*
 *  Function:  Dirdomcall
 *  Description:  installs a dirichlet domain as object
 *                  using the appropriate linkages
 *  Args IN: nothing
 *  Returns: nothing
 */
Dirdomcall()
{
#ifdef notdef
	float ddompt[4];  /* this contains the point of interest for the DDOm */
        ddompt[0] =  oposx;
        ddompt[1] =  oposy;
        ddompt[2] =  oposz;
        ddompt[3] =  1;
        obj = Dir_Domain(sendsyms,(3+maxpmat),ddompt,1,0,DDOMDEBUG); /* Euc & transp. */
        if(obj == NULL )
            fprintf(stderr,"Dirichlet domain was not loaded./n");
        else { 
	  fprintf(f, "define objhandle \n");
	  GeomFSave(obj, f, "");
        }
#endif
}

/*
 *	Function:  Utterlynewdirdom
 *	Description:	finds appropriate matrices and then calls Dirdomcall
 *	Args IN: nothing
 *	Returns: nothing
 */
Utterlynewdirdom()
{
#ifdef notdef
	float generic[4][4], generic1[4][4];  /* scratch matrices  */
	int i,j;

            /*  first build array of matrix things */
            sendsyms = (Transform(*))malloc((4+maxpmat)*sizeof(Transform));
#ifdef NOTDEF
            /* now fill the matrixes up */
            for(j= 0; j< maxpmat; j++) {
             MATXMAT4(ZSZHRP,thegroup[j],generic);
             MATXMAT4(generic,zszhrp,sendsyms[j]);
            }
            for(i= 0; i<8; i++) {
            for(j= 0; j< maxpmat; j++) {
             MATXMAT4(ZSZHRP,thegroup[j],generic);
             MATXMAT4(generic,thetrans[i],generic1);
             MATXMAT4(generic1,zszhrp,sendsyms[(i+1)*maxpmat+j]);
            }
            }
#endif
            /*  if we want to give just the generators  */
            for(j= 1; j< maxpmat; j++) {
             MATXMAT4(ZSZHRP,thegroup[j],generic);
             MATXMAT4(generic,zszhrp,sendsyms[j-1]);
            }
            for(j= 0; j< 4; j++) {
             MATXMAT4(ZSZHRP,thetrans[j],generic);
             MATXMAT4(generic,zszhrp,sendsyms[j+maxpmat-1]);
            }
            /* now call appropriately */
            Dirdomcall();
#endif
}
