/*
 *	callbacks.c:  Contains the callbacks from the control panels
 *
 *  Routines:  remainingcellsproc, newMVwindowproc, axesproc, symsprintproc,
 *				nameoffileproc, fillarrayproc, menubuttonproc, quitbuttonproc,
 *				quitbuttonproc, helpformproc, helpformexit, miscformproc,
 *				miscformexit, t[12]_preproc, s[1-6]_proc, b_proc
 *
 *   IMPORTANT NOTE:  the ARGUMENTS for these routines are the forms object 
 *						that was pressed (obj) and an (unused) integer. 
 *					  they RETURN nothing to fl_do_forms.
 *
 *  version II:   January 14,1992        by Olaf Holt
 */

#include "forms.h"
#include "linalg.h"
#include "geom.h"
#include "geomconfig.h"
#include "controlpanel.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAXCELLS	2054  /*  also found in eucsyms.c and arrays.c */

extern int maxwhich, whichcell, boxflag;
extern char t1_string[], t2_string[], t3_string[];
extern float parama, paramb, paramc, oposx, oposy, oposz;
extern float cells[][4][4], thetrans[][4][4];
extern short DDOMFLAG, ARRAYFLAG;
extern int t1_proc(), t2_proc(), t3_proc();

extern FILE* f;

#include "controlpanel.c"


void remainingcellsproc(FL_OBJECT *obj, long i)
{
    extern float rangex, rangey, rangez;
    int j;
       if(((j = atoi(fl_get_input(remainingcells)))<=maxwhich) && (j>0)) {
            whichcell = j;
            b_proc(NULL,99);
            rangex = 0; rangey = 0; rangez = 0;   /* so new arrays are built*/
        }else if(j != 0)
           fl_show_message("Can't have that many","displayed cells!","");
        fl_set_input(remainingcells,"");
}

#ifdef OLD
void newMVwindowproc( FL_OBJECT *obj, long i )
{
	char cmd[512];

	sprintf(cmd, "%s -b -M eucsymsobj &", MVPATH);
        system(cmd);
        writemessage("Calling up a MinneView window...");
}
#endif

void axesproc( FL_OBJECT *obj, long i )
{
        if (boxflag = fl_get_button(axes))
            writemessage("Axes turned on.");
        else
            writemessage("Axes turned off.");
        switchbox();
}

void symsprintproc( FL_OBJECT *obj, long i )
{
    fl_show_form(getafile,FL_PLACE_MOUSE,FALSE,NULL);
}

void nameoffileproc(FL_OBJECT *obj, long i)
{
    fl_hide_form(getafile);   
	printmat(t1_string,t2_string,fl_get_input(nameoffile));
}

void fillarrayproc(FL_OBJECT *obj, long i)
{
               ARRAYFLAG = 1;
                b_proc(NULL,99);   /* should fall into the default */
                ARRAYFLAG = 0;
}

void menubuttonproc(FL_OBJECT *obj, long i)
{
extern long mainmenu;
        dopup(mainmenu);
}

void quitbuttonproc(FL_OBJECT *obj, long i)
{
    system("/etc/killall MinneView");
        exit(0);
}

void helpformproc(FL_OBJECT *obj, long i)
{
    fl_show_form(helpform,FL_PLACE_SIZE,TRUE,"Eucsyms Help Window");
}

void helpformexit(FL_OBJECT *obj, long i)
{
    fl_hide_form(helpform);
}

void miscformproc(FL_OBJECT *obj, long i)
{
    fl_show_form(miscform,FL_PLACE_SIZE,TRUE,"Eucsyms Miscellaneous Controls");
}

void miscformexit(FL_OBJECT *obj, long i)
{
    fl_hide_form(miscform);
}

void t1_preproc(FL_OBJECT *obj, long i)
{
    sprintf(t1_string,"%s",fl_get_input(groupname));
    t1_proc();
}

void t2_preproc(FL_OBJECT *obj, long i)
{
    sprintf(t2_string,"%s",fl_get_input(displayingptgrpsyms));
    t2_proc();
}

void s1_proc(FL_OBJECT *obj, long i)  /* Scales the object */
{
	extern float params;
    float x;

    if((x = fl_get_slider_value(objectscalefactor))>0.001) {
		params = x;
		warp();
	}
}

void s2_proc(FL_OBJECT *obj, long i)   /* changes size of lattice, if appropriate */
{
	parama = fl_get_slider_value(aslider);
	ouax(0);
	warp();
	if (DDOMFLAG)
		Utterlynewdirdom();
}

void s3_proc(FL_OBJECT *obj, long i)   /* changes size of lattice, if appropriate */
{
	paramb = fl_get_slider_value(bslider);
	ouax(0);
	warp();
	if (DDOMFLAG)
		Utterlynewdirdom();
}

void s4_proc(FL_OBJECT *obj, long i)   /* changes size of lattice, if appropriate */
{
	paramc = fl_get_slider_value(cslider);
	ouax(0);
	warp();
	if (DDOMFLAG)
		Utterlynewdirdom();
}

void s5_proc(FL_OBJECT *obj, long i)  /* moves the object in the x,y directions */
{
    oposx = fl_get_positioner_xvalue(xyposition);
    oposy = fl_get_positioner_yvalue(xyposition);
	warp();
	if(DDOMFLAG)
		Dirdomcall();
}

void s6_proc(FL_OBJECT *obj, long i) /* moves the object in the z direction "up & down" */
{
    oposz = fl_get_dial_value(zposition);
	warp();
	if(DDOMFLAG)
		Dirdomcall();
}


/*
 *  Function: b_proc
 *  Description:  processes button events (x, wye, zed, and DONTPRESS)
 *  Args IN:  n:  which mousebutton was pressed, 1 is left, 2 is middle
 bp:  address of which windowbutton was pressed
 *  Returns: nothing
 */
void b_proc(FL_OBJECT *obj, long n)
{
  char bleach[20], newname[256];
  char *selectorstring, *name;  
  char labelstring[40];
  
  int i;
  float new[MAXCELLS][4][4];

  switch (n) {
  case 0:   /* defunct!   */
  case 1:   /* defunct!  */
  case 2:
    /* Don't use D. D.   */
    if((name = getenv("GEOMDATA")) == NULL) {
      name = GEOMDATA;
      if((selectorstring = 
	  fl_show_file_selector("Object to Load:",name,"","")) == NULL) break;
    } else {
      sprintf(newname,"%s/geom",name);
      if (opendir(name)) name = newname;
      if((selectorstring = 
	  fl_show_file_selector("Object to Load:", name,"","")) == NULL) break;
    }
    sprintf(t3_string, "%s",selectorstring);
    ouax(0);
    warp();
    t3_proc();
    break;
  case 3:
    /* use Dirichlet Domain!  
    DDOMFLAG = 1;
    Utterlynewdirdom();
    writemessage("Dirichlet domain installed.");
*/
    break;
  case 4:
    MATXMAT4(cells[whichcell-1],thetrans[0],cells[whichcell]);
    if (whichcell < MAXCELLS) whichcell++;
    else writemessage("Do you really want more translations?");
    break;
  case 5:
    MATXMAT4(cells[whichcell-1],thetrans[1],cells[whichcell]);
    if (whichcell < MAXCELLS) whichcell++;
    else writemessage("Do you really want more translations?");
    break;
  case 6:
    MATXMAT4(cells[whichcell-1],thetrans[2],cells[whichcell]);
    if (whichcell < MAXCELLS) whichcell++;
    else writemessage("Do you really want more translations?");
    break;
  case 7:
    MATXMAT4(cells[whichcell-1],thetrans[3],cells[whichcell]);
    if (whichcell < MAXCELLS) whichcell++;
    else writemessage("Do you really want more translations?");
    break;
  case 8:
    MATXMAT4(cells[whichcell-1],thetrans[4],cells[whichcell]);
    if (whichcell < MAXCELLS) whichcell++;
    else writemessage("Do you really want more translations?");
    break;
  case 9:
    MATXMAT4(cells[whichcell-1],thetrans[5],cells[whichcell]);
    if (whichcell < MAXCELLS) whichcell++;
    else writemessage("Do you really want more translations?");
    break;
  case 10:
    MATXMAT4(cells[whichcell-1],thetrans[6],cells[whichcell]);
    if (whichcell < MAXCELLS) whichcell++;
    else writemessage("Do you really want more translations?");
    break;
  case 11:
    MATXMAT4(cells[whichcell-1],thetrans[7],cells[whichcell]);
    if (whichcell < MAXCELLS) whichcell++;
    else writemessage("Do you really want more translations?");
    break;
  default:    /* this should happen eg for an array */
    break;
  }
  sprintf(bleach,"(%.0f,%.0f,%.0f)",cells[whichcell-1][0][3],cells[whichcell-1][1][3],cells[whichcell-1][2][3]);
  if (ARRAYFLAG)
    makearray();
  fl_unfreeze_object(latticeposition);
  fl_set_input(latticeposition,bleach);
  fl_freeze_object(latticeposition);
  sprintf(labelstring,"%3d",whichcell);
  fl_unfreeze_object(displayingcells);
  fl_set_input(displayingcells,labelstring);
  fl_freeze_object(displayingcells);
  if (whichcell > maxwhich) maxwhich = whichcell;

  fprintf(f, "(read geometry { define cellshandle { TLIST \n");
  for (i=0; i<whichcell; i++)
    TmTranspose(cells[i], new[i]);

  fputtransform(f, whichcell, new, 0);
  fprintf(f, "} } ) \n");
  fflush(f);
}

