/*
 *	arrays.c:   program contains routines to make an array
 *
 *	Routines:  makearray, RGmkarray
 *
 * 	July 30, 1990 			by Olaf Holt
 */
#include <math.h>
#include "linalg.h"

#define INRANGE ( (cells[whichcell][0][3] >= -rangex-.001) && (cells[whichcell][1][3] >= -rangey-.001) && (cells[whichcell][2][3] >= -rangez-.001) && (cells[whichcell][0][3] <= rangex+.001) && (cells[whichcell][1][3] <= rangey+.001) && (cells[whichcell][2][3] <= rangez+.001) )
   /*  function to determine whether something is in range for array funct */

#define MAXCELLS    2054      /*   Maximum number of cell replications  */
    /*  NOTE:  also needed in eucsyms.c!!! */
extern float cells[][4][4];   /*  translations used in the display   */
extern float thetrans[][4][4];  /*  translations used to build above trans.  */
extern int whichcell;   /* whichcell indicates how many translations */
float rangex = 0, rangey = 0, rangez = 0;
        /* stores extremes of the translations used   */

/*
 *  Function: RGmkarray
 *  Description:  The recursive kernel of the makearray routine
 *      assumes we are dealing with an abelian free group
 *  Args IN:  level:  how many recursive levels
 *  Returns: nothing
 */
RGmkarray(level)
int level;
{
int lastone,olastone;
if(level) {
    lastone = whichcell-1;
    if(whichcell < MAXCELLS) {
        RGmkarray(level-1);
    }
    MATXMAT4(cells[lastone],thetrans[level-1],cells[whichcell]);
    while (INRANGE) {
        olastone = whichcell;
        if(whichcell < MAXCELLS) {
            whichcell++;
            RGmkarray(level-1);
        }
        MATXMAT4(cells[olastone],thetrans[level-1],cells[whichcell]);
    }
    MATXMAT4(cells[lastone],thetrans[level+3],cells[whichcell]);
    while (INRANGE) {
        olastone = whichcell;
        if(whichcell < MAXCELLS) {
            whichcell++;
            RGmkarray(level-1);
        }
        MATXMAT4(cells[olastone],thetrans[level+3],cells[whichcell]);
    }
}
}

/*
 *  Function: makearray
 *  Description:  adds to the current translations as necessary
 *          for an array of cells, based on INRANGE  (must be convex)
 *  Args IN:  none
 *  Returns: nothing
 */
makearray()
{
float mtemp[4][4];
int i,owhich;

	rangex = (float)fabs((double)cells[whichcell-1][0][3]);
	rangey = (float)fabs((double)cells[whichcell-1][1][3]);
	rangez = (float)fabs((double)cells[whichcell-1][2][3]);

    /*  then make the array  */
    MATEQUAL4(mtemp,cells[whichcell-1]);

    whichcell = 1;

    RGmkarray((int)3);

/* add the necessary translation to all the elements of the array thus far   */
/*  THIS DOESN'T GET ALL OF THEM YET   */
    if(thetrans[3][0][3] != 0 || thetrans[3][1][3] != 0
        || thetrans[3][2][3] != 0 ) {
        owhich = whichcell;
        for(i = 0; i<owhich; i++) {
        MATXMAT4(cells[i],thetrans[3],cells[whichcell]);
        if (INRANGE)
            if(whichcell < MAXCELLS)
                whichcell++;
        }
    }

    /*   clean up    */
    if(mtemp[0][3] != cells[whichcell-1][0][3] ||
        mtemp[1][3] != cells[whichcell-1][1][3] ||
        mtemp[2][3] != cells[whichcell-1][2][3] ) {
    MATEQUAL4(cells[whichcell],mtemp);
    if(whichcell < MAXCELLS)
        whichcell++;
	else
		fl_show_message("Warning:  the array just created","is very large, and will","take some time to display.");
    }
}
