/*
 *	Ooglcalls.c:  contains routines for using MinneView's shared memory
 *
 *	Routines:
 *
 *  July 30,1990    mostly sketched out by Stuart Levy
 */

#include <stdio.h>
#include <stdlib.h>
#include "ooglutil.h"
#include "geomconfig.h"
#include "linalg.h"
#include "geom.h"
#include "geomclass.h"
#include "forms.h"


FILE *f = stdout;
Geom *obj, *edges;

extern float thegroup[][4][4];
extern float cells[][4][4];
extern Transform zszhrp,ZSZHRP,movemat;
extern float params,parama,paramb,paramc,oposx,oposy,oposz;
extern int whichcell,maxpmat;
extern int maxwhich;
extern int boxflag;
extern short DDOMFLAG;
extern short VERBOSEFLAG;
extern char    objname[256];
extern char *getenv();

/*
 *  Function:   switchbox
 *  Description:        turns on and off the axes
 *  Args IN:    none
 *  Returns:  nothing
 */
switchbox()
{
  fprintf(f,"(read geometry { ");
  if (boxflag == 1) {
    fprintf(f, "define axeshandle\n");
    GeomFSave(edges, f, "");
  } else {
    fprintf(f, "define axeshandle {}\n");
  }
  fprintf(f, "} )\n");
  fflush(f);
}

/*
*  Function:   Tooglinit
*  Description:        Initializes shared memory, sets up oogl objects
*  Args IN:    none
*  Returns:  nothing
*/
Tooglinit()
{
  char path[256];
  char *name;
  Transform new;
  int i = 0;
  char *dirs[4];
  
  if ((name = getenv("GEOMDATA")) == NULL) 
    name = GEOMDATA;
  if (access(name, 0) < 0) {
    fprintf(stderr, "Can't find directory %s.\nTry setting environment variable GEOMDATA.\n", name);
    exit(0);
  }
  dirs[0] = name;
  sprintf(path, "%s/geom", name);
  dirs[1] = path;
  sprintf(path, "%s/groups", name);
  dirs[2] = path;
  dirs[3] = NULL;
  filedirs(dirs);

  
  if((edges = GeomLoad(findfile(NULL, "xwyezed.vect"))) == NULL) {
    fprintf(stderr,"Couldn't load the cell vect file\n");
  } else if(VERBOSEFLAG) fprintf(stderr,"Vect file successfully loaded.");
  if((obj = GeomLoad(findfile(NULL, objname))) == NULL)
    fl_show_message("Object not found!","","");
  
  fprintf(f, "(geometry \n\
\n\
Eucsyms { = INST \n\
	transform : zszhrphandle \n\
	geom { = INST \n\
		transforms : cellshandle \n\
		geom { = LIST \n\
			{ : axeshandle } \n\
			{ = INST \n\
				transforms : thegrouphandle \n\
				geom { = INST \n\
					transform : ZSZHRPhandle \n\
					geom { = INST \n\
						transform : movemathandle \n\
						geom : objhandle \n\
					} \n\
				} \n\
    			} \n\
		} \n\
	} \n\
}	 \n\
)   \n");    
  TmIdentity(thegroup[0]);
  TmIdentity( cells[0] );
  fprintf(f, "(read geometry { define objhandle \n");
  GeomFSave(obj, f, "");
  fprintf(f, "} ) (read geometry {define thegrouphandle { TLIST\n");
  /* yes i know this is useless i'm doing it anyway... */
  TmTranspose(thegroup[0], new);

  fputtransform(f, 1, (float *)thegroup, 0);
  fprintf(f, "}\n");
  fprintf(f, "} ) (read geometry  { define cellshandle { TLIST\n");
  TmTranspose(cells[0],new); 
  fputtransform(f, 1, (float *)thegroup, 0);
  fprintf(f, "}\n");
  fprintf(f, "} )\n");
  /* axes */
  boxflag = 1;
  switchbox();
  fflush(f);
}

/*
 *  Function:   warp
 *  Description:  adds matrixes to the oogl structure to warp
 *		  space as parama, paramb, paramc, and params would have it.   
 *		  also moves the object to (oposx, oposy, oposz).
 *  Args IN:    none
 *  Returns:  nothing
 */
void
  warp()
{
  float rcond,z,work[4],det[2];
  int i,j,ipvt,info,job = 01,four = 4;
  
  Transform tmp,new;

  fprintf(f, "(read transform { define zszhrphandle {\n");
  TmTranspose(zszhrp, new); 
  fputtransform(f, 1, (float *)new, 0);
  fprintf(f, "} } )\n");
  if(fabs(DET3(zszhrp)) > SMALL) {
    MATEQUAL4(tmp,zszhrp);
    TmInvert(tmp,ZSZHRP);
    fprintf( f, "(read transform {define ZSZHRPhandle {\n");
     TmTranspose(ZSZHRP, new); 
    fputtransform(f, 1, (float *)new, 0);
    fprintf(f, "} } )\n");
  } else {
    fprintf(stderr,"Warning: attempted to invert sing. mat.\n");
  }
  if(!DDOMFLAG)
    Tm3Translate(movemat,oposx,oposy,oposz);
  else
    Tm3Translate(movemat,oposx*(1-params),oposy*(1-params),oposz*(1-params));
  TmScale(movemat,params,params,params);
  
  fprintf(f, "(read transform { define movemathandle {\n");
  TmTranspose(movemat, new); 
  fputtransform(f, 1, (float *)new, 0);
  fprintf(f, "} } )\n");
  fflush(f);
}
