#include <stdio.h>
#include <math.h>
#include "forms.h"
#include "4drotate.h"
#include "transform.h"

    double values[4];
    Transform T[4], final;

void
make_4drotation(a0, a1, angle, T)
int a0, a1;
double angle;
Transform T;
{
   double c,s;
   c = cos(angle);
   s = sin(angle);
   TmIdentity(T);
   T[a0][a0] = T[a1][a1] = c;
   T[a1][a0] = s;
   T[a0][a1] = -s;
}

void
recompute_matrix()
{
    /* get all the values: simpler to program! */
    values[0] = fl_get_slider_value(xw);
    values[1] = fl_get_slider_value(yw);
    values[2] = fl_get_slider_value(zw);
    values[3] = fl_get_slider_value(wt);
    /* recompute this matrix and concatenate them together */
    make_4drotation(0, 3, values[0], T[0]); 
    make_4drotation(1, 3, values[1], T[1]); 
    make_4drotation(2, 3, values[2], T[2]); 
    TmIdentity(T[3]);
    T[3][0][3] = values[3];
    TmConcat(T[0], T[1], final);
    TmConcat(final, T[2], final);
    TmConcat(final, T[3], final);

    {
    int i,j;
    printf("( xform-set targetgeom ");
    for (i=0; i<4; i++ )
      for (j=0; j<4; j++)
        printf(" %lf ", final[i][j]);
    printf(")\n");
    fflush(stdout);
    }
}

/*
 * Suppose you have a new object; you can send it to the viewer with:
 *    printf("(delete fred)");
 *    printf("(new-geometry fred {  ... })");
 *    printf("(ui-target fred)");
 *    fflush(stdout);
 */

init()
{
    float min = -3.14159, max = 3.14159;
    /* for external communication with viewer */
    printf("(ui-emotion-modename 4drotate)\n"); fflush(stdout);

    /* so we can use dbx on this */
    foreground();

    create_the_forms();
    fl_set_slider_bounds(xw, min, max);
    fl_set_slider_value(xw, 0.0);
    fl_set_slider_return(xw, 0);
    fl_set_slider_bounds(yw, min, max);
    fl_set_slider_value(yw, 0.0);
    fl_set_slider_return(yw, 0);
    fl_set_slider_bounds(zw, min, max);
    fl_set_slider_value(zw, 0.0);
    fl_set_slider_return(zw, 0);
    fl_set_slider_bounds(wt, -5.0, 5.0);
    fl_set_slider_value(wt, 0.0);
    fl_set_slider_return(wt, 0);
}

main()
{
    FL_OBJECT *this;
    init();
    fl_show_form(fourdrotate, FL_PLACE_SIZE, TRUE, NULL);
    do {
	this = fl_do_forms();
	}
    while (this != outofhere);

}

#define ROT 1
#define TRANS 2
void
changeval(FL_OBJECT *obj, long which)
{
    Transform T;
    int control = 0;
    switch (which)	{
	case XW:
	case YW:
	case ZW:
	    control = ROT;
	    break;
	case WT:
	    control = TRANS;
	default:
 	    break;	
	}
    recompute_matrix();
}

void
resetfunc(FL_OBJECT *obj, long which)
{
    fl_set_slider_value(xw, 0.0);
    fl_set_slider_value(yw, 0.0);
    fl_set_slider_value(zw, 0.0);
    fl_set_slider_value(wt, 0.0);
    recompute_matrix();
}

