/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef VECTDEF
#define VECTDEF

#ifndef NULL
#define NULL 0
#endif

#include	"bbox.h"

#define	VECT_MAGIC	0x4ac95203	/* For binary external format */

#define VECTMAGIC GeomMagic ('v', 1)	/* For checking whether a vect. */

typedef struct Vect Vect;

#define vcount(code)	(abs(code))
#define	vwrapped(code)	((code) < 0)

#define	vSane(v)   (0 <= (v)->ncolor && (v)->ncolor <= (v)->nvert && \
			(v)->nvec <= (v)->nvert && (v)->nvert < 9999999)


GeomClass	*VectMethods();
char	*VectName();
Vect	*VectLoad();
Vect	*VectFLoad();
Vect	*VectSave();
Vect	*VectFSave();
BBox	*VectBound();
Vect	*VectDraw();
int	VectShare();
int	VectPrivate();
void	RendLine();

int	VectSane(Vect *);

#endif /*VECTDEF*/
