/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef _STREAMPOOL_
#define	_STREAMPOOL_

#include <sys/types.h>
#include "handle.h"


	/*
	 * Common stream syntax
	 */

#define	CBRA	'{'
#define	CKET	'}'


	/*
	 * Open a stream-type Pool.
	 * Uses stream f if != NULL, otherwise opens the named file.
	 * The name is required anyway, to uniquely identify the pool.
	 */
extern Pool *PoolStreamOpen(char *name, FILE *f, int rw, HandleOps *ops);

	/*
	 * Open a temporary Pool.  Like PoolStreamOpen, but:
	 *   - the opened Pool is not listed as a input source for PoolInputFDs
	 *   - it is not added to the table of known Pools, so
	 *	it won't conflict with other Pools known by the same name.
	 * Uses stream f if != NULL, otherwise opens the named file.
	 * The name is not required -- it may be NULL.
	 */
extern Pool *PoolStreamTemp(char *name, FILE *f, int rw, HandleOps *ops);

	/*
	 * Return the set of file descriptors pool file descriptors we'd like
	 * polled for input.  Fills *maxfd with the highest+1 file descriptor.
	 * Returns 1 if some pool holds buffered input (i.e. don't let select()
	 * block), 0 otherwise.
	 */
extern int PoolInputFDs( fd_set *fds, int *maxfd );

	/*
	 * Given the fd mask returned by select(), call import() on
	 * all pools which have input.  Removes used fd's from *fds;
	 * decrements count for each fd used.
	 * Returns 1 if anything read from any pool, 0 otherwise.
	 */
extern int PoolInAll( fd_set *fds, int *count );

	/*
	 * Utility routine for XXXOut functions.
	 * Writes relevant text of h to the Pool based on p's output setup;
	 * returns 1 if associated data should be written too, 0 if not.
	 */
extern int PoolStreamOutHandle(Pool *p, Handle *h, int havedata);

extern int PoolDelete(Pool *p);

				/* How much to export when we do so? */
				/* Pass these values to PoolSetOType(). */
#define	  PO_ALL	0	/*   - use all handles and all data */
#define	  PO_HANDLES	1	/*   - use handles wherever possible, avoid data */
#define	  PO_DATA	2	/*   - data, no external refs */

extern FILE *PoolInputFile(Pool *);
extern FILE *PoolOutputFile(Pool *);
extern void  PoolDoReread(Pool *);
extern int   PoolOType(Pool *, int otype);
extern void  PoolSetOType(Pool *, int otype);
extern Pool *PoolByName(char *name);
extern char *PoolName(Pool *);


#endif /*_STREAMPOOL_*/
