/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef OOGLUTILDEF
#define OOGLUTILDEF

#include <stdio.h>

/*
 * Public definitions for miscellaneous useful OOGL internal stuff.
 */


#define	OOGLMagic(key, vers)    (0x9c800000 | ((key)&0x7f)<<16 | (vers)&0xffff )
#define OOGLIsMagic(magic)	(((magic) & 0xff800000) == 0x9c800000)

/*
 * Memory allocation
 */
extern void *(*OOG_NewP)(int);
extern void *(*OOG_RenewP)(void *, int);
extern void *OOG_NewE(int, char *);
extern void *OOG_RenewE(void *, int, char *);

#define	OOGLNew(t)		(t *)(*OOG_NewP)(sizeof(t))
#define	OOGLNewN(t,N)		(t *)(*OOG_NewP)(sizeof(t)*(N))
extern void (*OOGLFree)(void *);
#define	OOGLRenewN(t,p,N)	(t *)(*OOG_RenewP)(p, sizeof(t)*N)
#define	OOGLRealloc(t,p)	(t *)(*OOG_RenewP)(p, sizeof(t))

#define	OOGLNewE(t, errmsg)	(t *)OOG_NewE(sizeof(t), errmsg)
#define	OOGLNewNE(t,N, errmsg)	(t *)OOG_NewE(sizeof(t)*(N), errmsg)
#define	OOGLRenewNE(t,p,N, errmsg) (t *)OOG_RenewE(p, sizeof(t)*N, errmsg)

/*
 * Backward compatibility
 */
#define	GeomNew(t)		OOGLNew(t)
#define	GeomNewN(t,N)		OOGLNewN(t,N)
#define	GeomFree(p)		OOGLFree(p)
#define	GeomError  		OOGLError


/*
 * Error handling
 */
extern char *_GFILE;		/* Name of file where error is found */
extern int _GLINE;		/* Line number in file where error is found */
extern int OOGL_Errorcode;	/* Unique integer error code */

/* Kludge for obtaining file name and line number of error: */
#define OOGLError (_GFILE= __FILE__, _GLINE=__LINE__,0)?0:_OOGLError


/*
 * File-I/O utility routines
 */
extern int fnextc(FILE *, int flags);
extern int fexpectstr(FILE *, char *string);
extern int fexpecttoken(FILE *, char *string);
extern char *ftoken(FILE *, int fnextc_flags);
extern char *fdelimtok(char *delims, FILE *f, int flags);

extern int fgetnf(FILE *, int nfloats, float *floatp, int binary);
extern int fgetni(FILE *, int nints, int *intp, int binary);
extern int fgetns(FILE *, int nshorts, short *shortp, int binary);
extern int fgettransform(FILE *, int ntrans, float *transforms, int binary);
extern int fputtransform(FILE *, int ntrans, float *transforms, int binary);
extern FILE *fstropen(char *buf, int buflen, char *mode);

#define	NODATA	-2	/* async_fnextc() returns NODATA if
			 * none is immediately available
			 */

extern int async_fnextc(FILE *, int flags);
extern struct stdio_mark *stdio_setmark(struct stdio_mark *, FILE *);
extern int		  stdio_seekmark(struct stdio_mark *);

/*
 * int fnextc(FILE *f, int flags)
 *	Advances f to the next "interesting" character and
 *	returns it.  The returned char is ungetc'ed so the next getc()
 *	will yield the same value.
 *	Interesting depends on flags:
 *	  0 : Skip blanks, tabs, newlines, and comments (#...\n).
 *	  1 : Skip blanks, tabs, and comments, but newlines are interesting
 *		(including the \n that terminates a comment).
 *	  2 : Skip blanks, tabs, and newlines, but stop at #.
 *	  3 : Skip blanks and tabs but stop at # or \n.
 *
 * int
 * fexpectstr(FILE *file, char *string)
 *	Expect the given string to appear immediately on file.
 *	Return 0 if the complete string is found,
 *	else the offset+1 of the last matched char within string.
 *	The first unmatched char is ungetc'd.
 *
 * int
 * fexpecttoken(FILE *file, char *string)
 *	Expect the given string to appear on the file, possibly after
 *	skipping some white space and comments.
 *	Return 0 if found, else the offset+1 of last matched char in string.
 *	The first unmatched char is ungetc'd.
 *
 * char *ftoken(FILE *f, int flags)
 *	Skips uninteresting characters with fnextc(f, flags),
 *	then returns a "token" - string of consecutive interesting characters.
 *	Returns NULL if EOF is reached with no token, or if
 *	flags specifies stopping at end-of-line and this is encountered with
 *	no token found.
 *	The token is effectively statically allocated and will be
 *	overwritten by the next ftoken() call.
 */
/*
 * int fgetnf(file, nfloats, floatp, binary)
 *	Read an array of floats from a file in "ascii" or "binary" format.
 *	Returns number of floats successfully read, should = nfloats.
 *	"Binary" means "IEEE 32-bit floating-point" format.
 *
 * int fgetni(FILE *file, int nints, int *intsp, int binary)
 *	Read an array of ints from a file in "ascii" or "binary" format.
 *	Returns number of ints successfully read, should = nints.
 *	"Binary" means "32-bit big-endian" integer format.
 *
 * int fgetns(FILE *file, int nshorts, short *intsp, int binary)
 *	Read an array of shorts from a file in "ascii" or "binary" format.
 *	Returns number of shorts successfully read, should = nints.
 *	"Binary" means "16-bit big-endian" integer format.
 *
 * int fgettransform(FILE *f, int ntransforms, float *transforms, int binary)
 *	Reads 4x4 matrices from FILE.  Returns the number of matrices found,
 *	up to ntransforms.  Returns 0 if no numbers are found.
 *	On finding incomplete matrices (not a multiple of 16 floats)
 *	returns -1, regardless of whether any whole matrices were found.
 *	In ASCII (binary==0) mode, matrices are read in conventional order
 *	which is the transpose of the internal form.  Binary mode reads
 *	32-bit IEEE floats in internal order.
 *
 * int fputtransform(FILE *f, int ntransforms, float *transforms, int binary)
 *	Writes 4x4 matrices to FILE.  Returns the number written, i.e.
 *	ntransforms unless an error occurs.  See fgettransform() for format.
 *
 * FILE *fstropen(str, len, mode)
 *	Opens a string (buffer) as a "file".
 *	Mode is the usual "r", "w", etc. stuff.
 *	Reads should return EOF on encountering end-of-string,
 *	writes past end-of-string should also yield an error return.
 *	fclose() should be used to free the FILE after use.
 */

extern char *findfile(char *superfile, char *file);
extern void filedirs(char *dirs[]);
extern char **getfiledirs();

#include "porting.h"


#endif
