#include <stdio.h>
#include "mg.h"
#include "mgP.h"
#include "mgri.h"
#include "transform.h"
#include <ri/ri.h>

typedef struct mgricontext {
  struct mgcontext mgctx;	/* The mgcontext */
  int born;			/* Has window been displayed on the screen? */
  int dying;			/* Is the window being closed from titlebar */
  int win;			/* window ID, or 0 */
  int drawsfaces;
  int geomtype;			/* geom type:MG_EUCLIDEAN or MG_HYPERBOLIC */
  Transform W2C;		/* current W2C xform */
  Transform C2W;		/* current C2W xform */
  Transform W2S;		/* camera-to-screen xform */
  Transform O2S;		/* current object-to-screen xform */
  void (*callback)(struct mgricontext *c, int event);

    
  /* following are for NeXTs */
  char *nxwindow;
  char *nxview;
  RtToken qrmContext;
  RtToken windowresource;
  
} mgricontext;

#define _mgric		((mgricontext*)_mgc)

#define RI_X 0
#define RI_Y 1
#define RI_Z 2

#define SCRATCHSIZE  1024*32
RtPoint ript[SCRATCHSIZE];	/* points */
RtColor ricolor[SCRATCHSIZE];	/* rgb color */
RtPoint rinormal[SCRATCHSIZE];	/* normals */

/* here we define a simple normalization routine for HPt3 -> RtPoint */
/* we use this because it's somewhat faster then Hpt3Normalize       */

#define mgri_normalize(src,rtpoint) 				\
  { register HPoint3 *hpt3 = src;				\
    *(Point3 *)(rtpoint) = *(Point3 *)(hpt3);			\
    if(hpt3->w!=1.) {						\
	rtpoint[RI_X]/=hpt3->w;					\
	rtpoint[RI_Y]/=hpt3->w;					\
	rtpoint[RI_Z]/=hpt3->w;					\
    }								\
   }

void mgri_drawline(HPoint3 *p1, HPoint3 *p2);
void mgri_drawpoint(HPoint3 *p);
void mgri_flushbuffer();
