/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef MESHDEF
#define MESHDEF

#include "bbox.h"
#include "meshflag.h"

#ifndef NULL
#define NULL 0
#endif

#ifndef	FALSE
#define	FALSE 0
#endif

#define MESHMAGIC	GeomMagic ('m', 1)

typedef struct Mesh Mesh;


extern GeomClass *MeshMethods( void );
extern char	*MeshName( void );
extern Mesh	*MeshFLoad( FILE *, char * );
extern Mesh	*MeshLoad( char * );
extern Mesh	*MeshSave( Mesh *, char * );
extern Mesh	*MeshFSave( Mesh *, FILE * );
extern BBox	*MeshBound( Mesh *, Transform );
extern Mesh	*MeshDice( Mesh *, int (*proc)() );
extern Mesh	*MeshEvert( Mesh * );
extern Mesh	*MeshDraw( Mesh * );
extern Mesh	*MeshPick( Mesh *, Pick *, Appearance *, Transform );

#endif /*MESHDEF*/
