/* getusershell.c: minimal implementation of the getusershell() and
   endusershell() library routines for systems that don't have them.

Portions of this software are Copyright 1995 by Randall Atkinson and Dan
McDonald, All Rights Reserved. All Rights under this copyright are assigned
to the U.S. Naval Research Laboratory (NRL). The NRL Copyright Notice and
License Agreement applies to this software.

	History:

	Written at NRL for OPIE 2.0.
*/
#include "opie_cfg.h"

#if NEED_GETUSERSHELL
#include <stdio.h>

static FILE *fh = NULL;

static char *internal[] =
{"/bin/sh", "/bin/csh", NULL};
static int i = 0;
static char buffer[1024];

char *
     getusershell()
{
  if (!fh)
    fh = fopen("/etc/shells", "r");

  if (fh) {
    fgets(buffer, sizeof(buffer), fh);
    return buffer;
  } else {
    if (internal[i])
      return internal[i++];
    else
      return NULL;
  }
}

endusershell()
{
  if (fh) {
    fclose(fh);
    fh = NULL;
  }
}

#endif	/* NEED_GETUSERSHELL */
