------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUN-TIME COMPONENTS                         --
--                                                                          --
--                       S Y S T E M . I M G _ L L U                        --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--          Copyright (C) 1992-2007, Free Software Foundation, Inc.         --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains the routines for supporting the Image attribute for
--  unsigned (modular) integer types larger than Size Unsigned'Size, and also
--  for conversion operations required in Text_IO.Modular_IO for such types.

with System.Unsigned_Types;

package System.Img_LLU is
   pragma Pure;

   procedure Image_Long_Long_Unsigned
     (V : System.Unsigned_Types.Long_Long_Unsigned;
      S : in out String;
      P : out Natural);
   pragma Inline (Image_Long_Long_Unsigned);

   --  Computes Long_Long_Unsigned'Image (V) and stores the result in
   --  S (1 .. P) setting the resulting value of P. The caller guarantees
   --  that S is long enough to hold the result, and that S'First is 1.

   procedure Set_Image_Long_Long_Unsigned
     (V : System.Unsigned_Types.Long_Long_Unsigned;
      S : in out String;
      P : in out Natural);
   --  Stores the image of V in S starting at S (P + 1), P is updated to point
   --  to the last character stored. The value stored is identical to the value
   --  of Long_Long_Unsigned'Image (V) except that no leading space is stored.
   --  The caller guarantees that S is long enough to hold the result. S need
   --  not have a lower bound of 1.

end System.Img_LLU;
