// Copyright (C) 1999-2001 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of ccaudio.
//
// The exception is that, if you link the ccaudio library with other
// files to produce an executable, this does not by itself cause the
// resulting executable to be covered by the GNU General Public License.
// Your use of that executable is in no way restricted on account of
// linking the ccaudio library code into it.
//
// This exception does not however invalidate any other reasons why
// the executable file might be covered by the GNU General Public License.
//
// This exception applies only to the code released under the
// name ccaudio.  If you copy code from other releases into a copy of
// ccaudio, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own for ccaudio, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.

#include "private.h"
#include "audio2.h"
#include <cmath>
#include <cstdio>
#include <ctime>

extern int _osx_ccaudio_dummy;
int _osx_ccaudio_dummy = 0;

#if defined(OSX_AUDIO)

#include <CoreAudio/AudioHardware.h>

static unsigned devcount = 0;
static AudioDeviceID *devlist = NULL, *devinput = NULL, *devoutput = NULL;

static bool scanDevices(unsigned index)
{
	OSStatus err = noErr;
	UInt32 size;
	AudioDeviceID *id;
	unsigned i;

	if(!devlist)
	{
		if(AudioHardwareGetPropertyInfo(kAudioHardwarePropertyDevices, &size, NULL) != noErr)
			return false;

		devcount = size / sizeof(AudioDeviceID);	
		devlist = (AudioDeviceID *)malloc(size);
		
		if(AudioHardwareGetProperty(kAudioHardwarePropertyDevices, &size, (void *) devlist) != noErr)
		{
			free(devlist);
			return false;
		}

		size = sizeof(AudioDeviceID);
		if(AudioHardwareGetProperty(kAudioHardwarePropertyDefaultInputDevice, &size, &id) == noErr)
		{
			for(i = 0; i < devcount; ++i)
			{
				if(!memcmp(&devlist[i], &id, sizeof(AudioDeviceID)))
				{
					devinput = &devlist[i];
					break;
				}
			}
		}

                size = sizeof(AudioDeviceID);
                if(AudioHardwareGetProperty(kAudioHardwarePropertyDefaultOutputDevice, &size, &id) == noErr)
                {
                        for(i = 0; i < devcount; ++i)
                        {
				if(!memcmp(&devlist[i], &id, sizeof(AudioDeviceID)))
                                {
                                        devoutput = &devlist[i];
                                        break;
                                }
                        }
                }
	}
	if(!devcount)
		return false;

	if(index > devcount)
		return false;

	return true;	
}

using namespace ost;

bool Audio::hasDevice(unsigned index)
{
	return scanDevices(index);
}

AudioDevice *Audio::getDevice(unsigned index, DeviceMode mode)
{
	if(!scanDevices(index))
		return NULL;

	return NULL;
}


#endif
