/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: PGPKeyServerDialogs.cp,v 1.9 1999/03/10 02:52:16 heller Exp $
____________________________________________________________________________*/

#include <URegistrar.h>

#include "pgpDialogs.h"
#include "pgpKeyServerDialogCommon.h"
#include "pgpMem.h"

#include "CPGPSearchKeyServerGrafPort.h"
#include "CPGPSendToKeyServerGrafPort.h"
#include "PGPsdkUILibUtils.h"

const ResIDT	kSearchKeyServerDialogResID 			= 4757;
const ResIDT	kSearchKeyServerSpecificKeyDialogResID 	= 4758;
const ResIDT	kSendToKeyServerDialogResID 			= 4759;

	PGPError
pgpSearchKeyServerDialogPlatform(
	PGPContextRef						context,
	CPGPSearchKeyServerDialogOptions 	*options)
{
	PGPsdkUILibState	state;
	PGPError			err;
	
	PGPValidatePtr( options );
	
	err = EnterPGPsdkUILib( context, &state );
	if( IsntPGPError( err ) )
	{
		DialogRef	theDialog;
		ResIDT		dialogID;
		
		if( options->mKeyDescription[0] == 0 )
		{
			dialogID = kSearchKeyServerDialogResID;
		}
		else
		{
			dialogID = kSearchKeyServerSpecificKeyDialogResID;
		}
		
		RegisterClass_( CPGPSearchKeyServerGrafPortView );
		
		// Create standard Macintosh window and overlay PowerPlant onto it
		theDialog = CPGPSearchKeyServerGrafPortView::CreateDialog( dialogID );
		if( IsntNull( theDialog ) )
		{
			CPGPSearchKeyServerGrafPortView	*grafPortView;
			SInt16							saveWindowKind;
		
			/*
			**	OT/PPP has a bug which will cause any dialog in the
			** 	foreground to be disposed within OT/PPP if the user cancels
			**	the connection. Our fix is to whack the windowKind of the
			**	foreground window if it is dialogKind.
			*/
			
			saveWindowKind = GetWindowKind( theDialog );
			SetWindowKind( theDialog, kApplicationWindowKind );
				
			grafPortView = (CPGPSearchKeyServerGrafPortView *)
									GetWRefCon( theDialog );
			pgpAssertAddrValid( grafPortView, VoidAlign );
			
			err = grafPortView->SetOptions( context, options );
			if( IsntPGPError( err ) )
			{
				err = PGPSearchKeyServerDialogCommon( context,
						options->mServerList, options->mServerCount,
						options->mTLSContext, options->mFilter,
						CPGPSearchKeyServerGrafPortView::KeyServerCallbackProc,
						(PGPUserValue) grafPortView,
						options->mSearchAllServers, options->mNewKeys );
			}
			
			SetWindowKind( theDialog, saveWindowKind );

			delete( grafPortView );
			DisposeDialog( theDialog );
		}
		else
		{
			err = kPGPError_OutOfMemory;
		}
	}
		
	ExitPGPsdkUILib( &state );
	
	return( err );
}

	PGPError
pgpSendToKeyServerDialogPlatform(
	PGPContextRef						context,
	CPGPSendToKeyServerDialogOptions 	*options)
{
	PGPsdkUILibState	state;
	PGPError			err;
	
	PGPValidatePtr( options );
	
	err = EnterPGPsdkUILib( context, &state );
	if( IsntPGPError( err ) )
	{
		DialogRef	theDialog;

		RegisterClass_( CPGPSendToKeyServerGrafPortView );
		
		// Create standard Macintosh window and overlay PowerPlant onto it
		theDialog = CPGPSearchKeyServerGrafPortView::CreateDialog(
							kSendToKeyServerDialogResID );
		if( IsntNull( theDialog ) )
		{
			CPGPSendToKeyServerGrafPortView	*grafPortView;
			SInt16							saveWindowKind;
		
			/*
			**	OT/PPP has a bug which will cause any dialog in the
			** 	foreground to be disposed within OT/PPP if the user cancels
			**	the connection. Our fix is to whack the windowKind of the
			**	foreground window if it is dialogKind.
			*/
			
			saveWindowKind = GetWindowKind( theDialog );
			SetWindowKind( theDialog, kApplicationWindowKind );
				
			grafPortView = (CPGPSendToKeyServerGrafPortView *)
									GetWRefCon( theDialog );
			pgpAssertAddrValid( grafPortView, VoidAlign );
			
			err = grafPortView->SetOptions( context, options );
			if( IsntPGPError( err ) )
			{
				err = PGPSendToKeyServerDialogCommon( context,
						options->mServerList, options->mTLSContext,
						options->mKeysToSend, CPGPSearchKeyServerGrafPortView::
						KeyServerCallbackProc, (PGPUserValue) grafPortView,
						options->mFailedKeys );
			}
			
			SetWindowKind( theDialog, saveWindowKind );

			delete( grafPortView );
			DisposeDialog( theDialog );
		}
		else
		{
			err = kPGPError_OutOfMemory;
		}
	}
		
	ExitPGPsdkUILib( &state );
	
	return( err );
}