/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CPGPUIGrafPortView.cp,v 1.4 1999/03/10 02:38:54 heller Exp $
____________________________________________________________________________*/

#include "MacStrings.h"
#include "pgpDialogs.h"
#include "pgpMem.h"

#include "CPGPUIGrafPortView.h"

CPGPUIGrafPortView::CPGPUIGrafPortView(LStream *inStream)
	: CPGPModalGrafPortView(inStream)
{
	mOptions 	= NULL;
	mContext	= kInvalidPGPContextRef;
}

CPGPUIGrafPortView::~CPGPUIGrafPortView()
{
}

	PGPError
CPGPUIGrafPortView::SetOptions(
	PGPContextRef 		context,
	CPGPDialogOptions 	*options)
{
	PGPError	err = kPGPError_NoErr;
	
	PGPValidateParam( PGPContextRefIsValid( context ) );
	PGPValidatePtr( options );
	
	mContext = context;
	mOptions = options;
	
	if( IsntNull( options->mWindowTitle ) )
	{
		Str255	title;

		CToPString( options->mWindowTitle, title );
		SetWTitle( GetMacPort(), title );
	}

	return( err );
}