/*____________________________________________________________________________
	main.c
	
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: main.c,v 1.10 1999/03/10 02:45:27 heller Exp $
____________________________________________________________________________*/

#include "pgpConfig.h"	/* or pgpConfig.h in the CDK */

#include <CodeFragments.h>
#include <Gestalt.h>

#include "MacBasics.h"
#include "MacErrors.h"
#include "pgpDebug.h"
#include "pgpErrorsPriv.h"
#include "pgpMem.h"
#include "pgpUtilities.h"

PGP_BEGIN_C_DECLARATIONS

pascal OSErr 	INIT_PGPsdk(CFragInitBlock *initBlock);
pascal void		TERM_PGPsdk(void);

pascal OSErr 	__initialize(const CFragInitBlock *theInitBlock);
pascal OSErr 	__terminate(void);

static PGPBoolean	sInitializedLibrary = FALSE;

PGP_END_C_DECLARATIONS

	pascal OSErr
INIT_PGPsdk(CFragInitBlock *initBlock)
{
	OSErr	err = noErr;
	
	err = __initialize( initBlock );
	if( IsntErr( err ) )
	{
		err	= PGPErrorToMacError( PGPsdkInit() );
		if( IsntErr( err ) )
		{
			sInitializedLibrary = TRUE;
		}
	}

	pgpAssert( IsntErr( err ) );

	return( err );
}

	pascal void
TERM_PGPsdk(void)
{
	if( sInitializedLibrary )
	{
		PGPsdkCleanup();
		sInitializedLibrary = FALSE;
	}
	
	__terminate();
}
