/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CWaitNextEventPatcher.h,v 1.4 1999/03/10 02:41:57 heller Exp $
____________________________________________________________________________*/

#pragma once 

#include "CPatcher.h"

class CWaitNextEventPatcher	:	public	CPatcher {
public:
#if	TARGET_RT_MAC_CFM
	enum {kProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(Boolean)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(EventMask)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(EventRecord *)))
		| STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(UInt32)))
		| STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(RgnHandle)))};
#else
	enum {kProcInfo = 0};
	typedef pascal Boolean 			(*WaitNextEventProc)(EventMask eventMask,
										EventRecord * theEvent,
										UInt32 sleep, RgnHandle mouseRgn);
#endif
		
									CWaitNextEventPatcher();
	virtual							~CWaitNextEventPatcher();

protected:
	static CWaitNextEventPatcher *	sWaitNextEventPatcher;
	
	virtual Boolean					NewWaitNextEvent(EventMask eventMask,
										EventRecord * theEvent,
										UInt32 sleep, RgnHandle mouseRgn);

	virtual Boolean					OldWaitNextEvent(EventMask eventMask,
										EventRecord * theEvent,
										UInt32 sleep, RgnHandle mouseRgn);	

	static pascal Boolean			WaitNextEventCallback(EventMask eventMask,
										EventRecord *theEvent, UInt32 sleep,
										RgnHandle mouseRgn);
};
