/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CWaitNextEventDispatcher.h,v 1.4 1999/04/10 11:15:30 jason Exp $
____________________________________________________________________________*/

#pragma once 

#include "CWaitNextEventPatcher.h"

typedef struct EventParamsS {
	Boolean			result;
	EventMask		eventMask;
	EventRecord *	theEvent;
	UInt32			sleep;
	RgnHandle		mouseRgn;
} SEventParams, * SEventParamsPtr;

class CWaitNextEventDispatcher	:	public	CWaitNextEventPatcher {
public:
							CWaitNextEventDispatcher();
	virtual					~CWaitNextEventDispatcher();
	
	static SEventParamsPtr	GetEventParamsPtr() { return &sEventParams; }
		
protected:
	bool					mCalled;
	
	static SEventParams		sEventParams;
	
	virtual Boolean			NewWaitNextEvent(EventMask eventMask,
								EventRecord * theEvent,
								UInt32 sleep, RgnHandle mouseRgn);
	
	virtual void			FirstEvent() { }
	
	virtual void			InitEventParms(EventMask eventMask,
								EventRecord * theEvent, UInt32 sleep,
								RgnHandle mouseRgn);
	virtual void			DispatchEvent();

	virtual void			PreWaitNextEvent() { }
	
	virtual void			HandleEveryEvent() { }
	virtual void			HandleIdleEvents() { }
	
	virtual void			HandleNullEvent();
	virtual void			HandleMouseDown() { }
	virtual void			HandleMouseUp() { }
	virtual void			HandleKeyDown() { }
	virtual void			HandleKeyUp() { }
	virtual void			HandleAutoKeyEvent() { }
	virtual void			HandleUpdateEvent() { }
	virtual void			HandleDiskEvent() { }
	virtual void			HandleActivateEvent() { }
	virtual void			HandleOSEvent() { }
	virtual void			HandleHighLevelEvent() { }
};
