/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CPatcher.cp,v 1.7 1999/04/02 09:01:08 jason Exp $
____________________________________________________________________________*/

#include "CPGPException.h"
#include "CPatcher.h"



CPatcher::CPatcher()
	:	mOldRoutine(nil)
{
}


CPatcher::~CPatcher()
{
}



	void
CPatcher::Patch(
	SInt16			inTrapNum,
	ProcInfoType	inProcInfo,
	ProcPtr			inProc)
{
	UniversalProcPtr	theNewRoutine;

#if	TARGET_RT_MAC_CFM
	theNewRoutine =
		(UniversalProcPtr) ::NewRoutineDescriptor(	(ProcPtr) inProc,
													inProcInfo,
													GetCurrentArchitecture());
	PGPThrowIfMemFail_(theNewRoutine);
#else
	theNewRoutine = (UniversalProcPtr) inProc;
#endif

	if (inTrapNum & 0x0800){
		mOldRoutine = ::GetToolTrapAddress(inTrapNum);
		::SetToolTrapAddress(	(UniversalProcPtr) theNewRoutine,
								inTrapNum);
	} else {
		mOldRoutine = ::GetOSTrapAddress(inTrapNum);
		::SetOSTrapAddress(	(UniversalProcPtr) theNewRoutine,
							inTrapNum);
	}
}
