/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CEventAvailPatcher.h,v 1.3 1999/03/10 02:33:19 heller Exp $
____________________________________________________________________________*/

#pragma once 

#include "CPatcher.h"

class CEventAvailPatcher	:	public	CPatcher {
public:
#if	TARGET_RT_MAC_CFM
	enum {kProcInfo = kPascalStackBased
		| RESULT_SIZE(SIZE_CODE(sizeof(Boolean)))
		| STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(EventMask)))
		| STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(EventRecord *)))};
#else
	enum {kProcInfo = 0};
	typedef pascal Boolean 			(*EventAvailProc)(EventMask eventMask,
										EventRecord * theEvent);
#endif
		
									CEventAvailPatcher();
	virtual							~CEventAvailPatcher();

protected:
	static CEventAvailPatcher *		sEventAvailPatcher;
	
	virtual Boolean					NewEventAvail(EventMask eventMask,
										EventRecord * theEvent);

	virtual Boolean					OldEventAvail(EventMask eventMask,
										EventRecord * theEvent);	

	static pascal Boolean			EventAvailCallback(EventMask eventMask,
										EventRecord *theEvent);
};
