/*____________________________________________________________________________
	Copyright (C) 1997-1998 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: PGPtoolsUtils.h,v 1.16 1999/03/10 02:59:25 heller Exp $
____________________________________________________________________________*/

#pragma once

#include <TArray.h>

#include "pgpMacMemory.h"
#include "pgpMacWiping.h"

#include "pgpKeys.h"
#include "pgpPubTypes.h"

#pragma warn_hidevirtual off
template class TArray<FSSpec>;
#pragma warn_hidevirtual reset

#ifdef __cplusplus
extern "C" {
#endif

#include "pgpTools.h"

OSStatus		GetFileOrClipboard(
						PGPtoolsOperation	operation,
						ConstStr255Param openButtonTitle,
						FSSpec *fsSpec, Boolean *useClipboard);
void			GetErrorString(CToolsError err, StringPtr errorStr);
Boolean			ShouldReportError(CToolsError err);
OSStatus		PromptForSignatureSourceFile(const FSSpec *sigFileSpec,
						FSSpec *sourceFileSpec);
Boolean			HaveDirWriteAccess(short vRefNum, long dirID);
OSStatus		RemoveChildAndDuplicateSpecsFromList(
						TArray<FSSpec>	*specList);

typedef struct
{
	Boolean		isEncrypted;
	Boolean		isSigned;
	Boolean		isDetachedSig;
	Boolean		isKeyShareFile;
	Boolean		isPGPFile;
	Boolean		maybePGPFile;
} FileKindInfo;


OSStatus	GetPGPFileKindInfo( const FSSpec *spec, FileKindInfo *info );
PGPError	GetWipingPatternList(PGPContextRef context, PGPUInt32 numPasses,
						PGPWipingPattern **patterns);

#ifdef __cplusplus
}
#endif

