/*____________________________________________________________________________
	Copyright (C) 1998 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CPGPtoolsWipeFreeSpaceTask.cp,v 1.5 1999/03/10 02:41:17 heller Exp $
____________________________________________________________________________*/

#include <LPeriodical.h>
#include <LProgressBar.h>
#include <UReanimator.h>
#include <URegistrar.h>

#include "CGAProgressDialog.h"
#include "CPGPStDialogHandler.h"
#include "MacFiles.h"
#include "MacStrings.h"
#include "pflPrefs.h"
#include "pflPrefTypes.h"
#include "pgpMem.h"
#include "PGPOpenPrefs.h"
#include "pgpUtilities.h"

#include "CPGPtoolsWipeFreeSpaceTask.h"
#include "CWipeFreeSpaceWizardDialog.h"
#include "pgpClientPrefs.h"
#include "PGPtoolsResources.h"
#include "PGPtoolsUtils.h"

const ResIDT	kWFSSinglePassProgressDialogResID	= 8000;
const ResIDT	kWFSMultiPassProgressDialogResID	= 8001;

class CWipeFreeSpaceProgressDialog : public CGAProgressDialog, public LPeriodical
{
public:

	enum
	{
		class_ID 		= 'WFSP',
		kPassBarPaneID	= 'Pass'
	};
	
					CWipeFreeSpaceProgressDialog();
					CWipeFreeSpaceProgressDialog(LStream *inStream);
	virtual			~CWipeFreeSpaceProgressDialog();

	virtual	void	SetCompletedPasses(UInt32 completedPasses);
	virtual	void	SetTotalPasses(UInt32 totalPasses);
	virtual void	SpendTime(const EventRecord &inMacEvent);

protected:

	LProgressBar	*mPassBar;
	UInt32			mTotalPasses;
	UInt32			mCompletedPasses;
	
	virtual void	FinishCreateSelf(void);

};

CWipeFreeSpaceProgressDialog::CWipeFreeSpaceProgressDialog()
{
	mTotalPasses 		= 0;
	mCompletedPasses	= 0;
}

CWipeFreeSpaceProgressDialog::CWipeFreeSpaceProgressDialog(LStream *inStream)
	: CGAProgressDialog(inStream)
{
	mTotalPasses 		= 0;
	mCompletedPasses	= 0;
}

CWipeFreeSpaceProgressDialog::~CWipeFreeSpaceProgressDialog()
{
}

	void
CWipeFreeSpaceProgressDialog::FinishCreateSelf(void)
{
	CGAProgressDialog::FinishCreateSelf();
	
	mPassBar = (LProgressBar *) FindPaneByID( kPassBarPaneID );
	pgpAssertAddrValid( mPassBar, VoidAlign ); 
}

	void
CWipeFreeSpaceProgressDialog::SpendTime(const EventRecord &inMacEvent)
{
	mProgressBarObj->SpendTime( inMacEvent );
	mPassBar->SpendTime( inMacEvent );
}

	void
CWipeFreeSpaceProgressDialog::SetTotalPasses(UInt32 totalPasses)
{
	mTotalPasses = totalPasses;
}


	void
CWipeFreeSpaceProgressDialog::SetCompletedPasses(UInt32 completedPasses)
{
	UInt32	percentComplete;
	
	pgpAssert( mTotalPasses != 0 );
	
	mCompletedPasses = completedPasses;
	if( mCompletedPasses > mTotalPasses )
		mCompletedPasses = mTotalPasses;
		
	percentComplete = (UInt32)
		(( (float) mCompletedPasses * 100.0 ) / (float) mTotalPasses);
	
	mPassBar->SetValue( percentComplete );
}

CPGPtoolsWipeFreeSpaceTask::CPGPtoolsWipeFreeSpaceTask() :
		CPGPtoolsTask( kPGPtoolsWipeFreeSpaceOperation )
{
	mVRefNum		= -1;
	mNumPasses		= 0;
	mContext		= kInvalidPGPContextRef;
	mProgressDialog	= NULL;
	mWiping			= FALSE;

	Get1AnimatedCursor( kAnimatedCursorResID, &mCursorRef );
}

CPGPtoolsWipeFreeSpaceTask::~CPGPtoolsWipeFreeSpaceTask(void)
{
	delete mProgressDialog;
	mProgressDialog = NULL;

	if( IsntNull( mCursorRef ) )
		DisposeAnimatedCursor( mCursorRef );
}

	CToolsError
CPGPtoolsWipeFreeSpaceTask::WipeFreeSpace(void)
{
	CToolsError		err;
	ResIDT			progressDialogResID;
	
	RegisterClass_( CWipeFreeSpaceProgressDialog );
	
	if( mNumPasses > 1 )
	{
		progressDialogResID = kWFSMultiPassProgressDialogResID;
	}
	else
	{
		progressDialogResID = kWFSSinglePassProgressDialogResID;
	}
	
	mProgressDialog = (CWipeFreeSpaceProgressDialog *)
				LWindow::CreateWindow( progressDialogResID, NULL );
	if( mProgressDialog != NULL )
	{
		Str255				volumeName;
		Str255				msg;
		PGPWipingPattern	*patternList;
		
		UReanimator::LinkListenerToControls( this, mProgressDialog,
						progressDialogResID );
		
		GetVolumeName( mVRefNum, volumeName );
		
		mProgressDialog->GetCaption( msg );
		PrintPString( msg, msg, volumeName );
		mProgressDialog->SetCaption( msg );
		
		mProgressDialog->Show();
		mProgressDialog->Select();
		mProgressDialog->Activate();
		mProgressDialog->UpdatePort();
		
		err.pgpErr = GetWipingPatternList( mContext, mNumPasses, &patternList );
		if( err.IsntError() )
		{
			mWiping = TRUE;
			
			err.err = pgpWipeVolumeFreeSpace( mVRefNum, volumeName,
							mNumPasses, mNumPasses, patternList,
							WipeVolumeEventHandlerShell, this );
			pgpAssert( err.IsntError() );
			
			mWiping = FALSE;
			
			InitCursor();
			FlushEvents( mDownMask | mUpMask | keyDownMask, 0 );

			PGPFreeData( patternList );
		}
	
		mProgressDialog->Hide();
		delete mProgressDialog;
		mProgressDialog = NULL;
	}
	else
	{
		err.pgpErr = kPGPError_OutOfMemory;
	}
	
	return( err );
}

	CToolsError
CPGPtoolsWipeFreeSpaceTask::SetParams(
	PGPContextRef	context,
	short 			vRefNum,
	PGPUInt32		numPasses)
{
	CToolsError	err;
	
	if( vRefNum == 0 )
		vRefNum = -1;
		
	err.err = pgpCanWipeVolumeFreeSpace( vRefNum );
	if( err.IsntError() )
	{
		mContext	= context;
		mVRefNum 	= vRefNum;	

		if( numPasses == 0 )
		{
			PGPPrefRef	prefRef;
			
			err.pgpErr = PGPOpenClientPrefs( PGPGetContextMemoryMgr( context ), &prefRef );
			if( err.IsntError() )
			{
				err.pgpErr = PGPGetPrefNumber( prefRef, kPGPPrefDiskWipePasses,
									&mNumPasses );
				pgpAssert( err.IsntError() );

				(void) PGPClosePrefFile( prefRef );
			}
		}
		else
		{
			mNumPasses = numPasses;	
		}
	}

	return( err );
}

	OSStatus
CPGPtoolsWipeFreeSpaceTask::WipeVolumeEventHandlerShell(
	const VolumeWipeEvent 	*event,
	PGPUserValue 			userValue)
{
	CPGPtoolsWipeFreeSpaceTask	*task = (CPGPtoolsWipeFreeSpaceTask *) userValue;
	
	return( task->WipeVolumeEventHandler( event ) );
}

	OSStatus
CPGPtoolsWipeFreeSpaceTask::WipeVolumeEventHandler(const VolumeWipeEvent *event)
{
	OSStatus	err = noErr;
	
	switch( event->type )
	{
		case kVolumeWipeEvent_GatheringInfo:
		{
			EventRecord	dummyEvent;
			
			mProgressDialog->SpendTime( dummyEvent );
			break;
		}
		
		case kVolumeWipeEvent_BeginPass:
		{
			if( event->beginPass.passIndex == 1 )
			{
				mProgressDialog->SetIndeterminateFlag( FALSE );
				mProgressDialog->SetTotalOperations( event->beginPass.totalSectorsToWipe );
				mProgressDialog->SetTotalPasses( event->beginPass.totalPasses );
			}
			
			mProgressDialog->SetCompletedOperations( 0 );
			
			break;
		}
		
		case kVolumeWipeEvent_EndPass:
		{
			if( IsntErr( event->endPass.passError ) )
				mProgressDialog->SetCompletedPasses( event->endPass.passIndex );
				
			break;
		}
		
		case kVolumeWipeEvent_WipeProgress:
		{
			mProgressDialog->SetCompletedOperations( event->progress.numSectorsWiped );
			
			if( IsntNull( mCursorRef ) )
				AnimateCursor( mCursorRef );
				
			break;
		}
	}
	
	if( IsntErr( err ) )
	{
		EventRecord	event;
		
		if( GetOSEvent( mDownMask | mUpMask, &event ) &&
			event.what == mouseDown )
		{
			Int16		windowPart;
			WindowPtr	macWindowP;
			
			windowPart = FindWindow( event.where, &macWindowP );
			if( macWindowP == mProgressDialog->GetMacPort() &&
				windowPart == inContent )
			{
				LWindow		*theWindow;

				theWindow = LWindow::FetchWindowObject( macWindowP );
				if (theWindow != nil)
				{
					theWindow->HandleClick( event, windowPart );
					if( ! mWiping )
						err = userCanceledErr;
				}
			}
		}
	}

	return( err );
}

	void
CPGPtoolsWipeFreeSpaceTask::ListenToMessage(
	MessageT 	inMessage,
	void 		*ioParam)
{
	(void) ioParam;
	
	switch( inMessage )
	{
		case msg_Cancel:
			mWiping = FALSE;
			break;
	}
}
