/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: CSignDialog.cp,v 1.51 1999/03/10 02:39:57 heller Exp $
____________________________________________________________________________*/

#include <Fonts.h>

#include <LCheckBox.h>
#include <LPushButton.h>
#include <LTextGroupBox.h>
#include <LCheckBox.h>
#include <LLittleArrows.h>
#include <LRadioButton.h>
#include <LTableView.h>
#include <LTableMonoGeometry.h>
#include <LTableSingleSelector.h>
#include <LTableArrayStorage.h>
#include <UGAColorRamp.h>
#include <URegistrar.h>
#include <UDesktop.h>
#include <UDrawingUtils.h>

#include <string.h>

#include "CSignDialog.h"

#include "CKeyTable.h"
#include "CKeyInfoWindow.h"
#include "CWarningAlert.h"
#include "CGADurationEditField.h"
#include "ResourceConstants.h"
#include "CPGPKeys.h"
#include "CSecureMemory.h"
#include "CColumnTable.h"

#include "pgpClientLib.h"
#include "pgpUserInterface.h"

#include "pgpMem.h"
#include "pgpErrors.h"
#include "MacStrings.h"
#include "pgpClientPrefs.h"

const Int16		kUserIDColumnWidth		=	220;
const Int16		kFingerprintColumnWidth	=	280;
const Int16		kUserIDStringLength		=	256;

enum	{
			kStringListID			= 1019,
			kAdvancedOptionsStringID= 1,
			kFewerOptionsStringID,
			kNameColumnStringID,
			kFingerprintColumnStringID,
			kDuplicateCertID,
			kEnterPassphrasePromptStringID,
			kPhotographStringID,
			kUnknownStringID,
			kBadExpirationStringID
		};

class	CSignTable	:	public CColumnTable
{
public:
	enum { class_ID = 'uidL' };
						CSignTable(LStream *inStream)
							: CColumnTable(inStream) { };
	virtual				~CSignTable() { };
	void				FinishCreateSelf();
	virtual Boolean		GetCellDrawData(
								STableCell			inCell,
								ResIDT				&iconID,
								Int16				&indentLevel,
								Str255				data,
								StyleParameter		&style );
private:
};

CSignDialog::CSignDialog()
{
	RegisterClass_(CSignTable);
}

CSignDialog::CSignDialog(LStream *inStream)
	: LGADialog(inStream)
{
	RegisterClass_(CSignTable);
}

CSignDialog::~CSignDialog()
{
	if(IsntNull(mUserIDs))
		pgpFree(mUserIDs);
}

	void
CSignDialog::FinishCreateSelf()
{
	LLittleArrows	*arrowsObj;
	UInt32			timeNow;

	LGADialog::FinishCreateSelf();
	
	mUserIDs = NULL;
	mAdvancedMode = FALSE;
	mExportCheckbox = (LCheckBox *) FindPaneByID(kExportCheckbox);
	mAdvancedButton = (LPushButton *) FindPaneByID(kAdvancedButton);
	mAdvancedButton->AddListener(this);
	mSignButton = (LPushButton *) FindPaneByID(kSignButton);
	mCancelButton = (LPushButton *) FindPaneByID(kCancelButton);
	//mCancelButton->AddListener(this);
	mSignTypesGroup = (LTextGroupBox *) FindPaneByID(kSignTypesGroup);
	mExpireTypesGroup = (LTextGroupBox *) FindPaneByID(kExpireTypesGroup);
	mSignN0Radio = (LRadioButton *) FindPaneByID(kSignTypeN0Radio);
	mSignE0Radio = (LRadioButton *) FindPaneByID(kSignTypeE0Radio);
	mSignE1Radio = (LRadioButton *) FindPaneByID(kSignTypeE1Radio);
	mSignN2Radio = (LRadioButton *) FindPaneByID(kSignTypeN2Radio);
	mNeverExpireRadio = (LRadioButton *) FindPaneByID(kNeverExpireRadio);
	mExpirationRadio = (LRadioButton *) FindPaneByID(kExpirationRadio);
	mScroller = (LActiveScroller *) FindPaneByID(kUserIDScroller);
	mDomainEdit = (LEditText *) FindPaneByID(kDomainEdit);
	SwitchTarget(mDomainEdit);
	
	mExpirationDate = (CGADurationEditField *) FindPaneByID(kExpirationDate);
	mExpirationDate->SetDurationType(kDateDurationType);
	GetDateTime( &timeNow );
	mExpirationDate->SetDurationValue( timeNow );
	arrowsObj = (LLittleArrows *) FindPaneByID(kExpirationArrows);
	mLastArrowValue = arrowsObj->GetValue();
	arrowsObj->AddListener(this);
}

	void
CSignDialog::SetUserIDs(PGPKeyRef		signer,
						KeyTableRef		*userIDs,
						Int32			numUserIDs)
{
	CSignTable *uidList;
	
	mSigner = signer;
	mUserIDs = userIDs;
	mNumUserIDs = numUserIDs;
	uidList = (CSignTable *)FindPaneByID(kUserIDList);
	for( Int16 inx=0; inx < numUserIDs; inx++ )
	{
		uidList->InsertRows(1, LArray::index_Last,
			&userIDs[inx], sizeof(KeyTableRef), true);
	}
	Show();
}

	void
CSignDialog::DrawSelf()
{
	Rect	frame;
	
	LGADialog::DrawSelf();
	FocusDraw();
	mScroller->CalcPortFrameRect(frame);
	InsetRect(&frame, -1, -1);
	RGBForeColor(&UGAColorRamp::GetColor(colorRamp_Gray7));
	MoveTo(frame.left, frame.bottom-1);
	LineTo(frame.left, frame.top - 16);
	LineTo(frame.right - 1, frame.top - 16);
	RGBForeColor(&UGAColorRamp::GetColor(colorRamp_White));
	MoveTo(frame.left+1, frame.bottom - 1);
	LineTo(frame.right - 1, frame.bottom - 1);
	LineTo(frame.right - 1, frame.top - 15);	
}

	PGPError
CSignDialog::GetParams(
	PGPUInt32		*trustLevel,
	PGPBoolean		*exportable,
	PGPUInt32		*expireDays )
{
	PGPError	err = kPGPError_NoErr;
	
	*expireDays = 0;
	if(mAdvancedMode)
	{
		if(mSignN0Radio->GetValue())
		{
			*trustLevel = 0;
			*exportable = FALSE;
		}
		else if(mSignE0Radio->GetValue())
		{
			*trustLevel = 0;
			*exportable = TRUE;
		}
		else if(mSignE1Radio->GetValue())
		{
			*trustLevel = 1;
			*exportable = TRUE;
		}
		else if(mSignN2Radio->GetValue())
		{
			*trustLevel = 2;
			*exportable = FALSE;
		}
		if( mExpirationRadio->GetValue() > 0 )
		{
			UInt32		expireDate,
						timeNow;
			
			expireDate = mExpirationDate->GetDurationValue();
			GetDateTime(&timeNow);
			if( timeNow > expireDate )
			{
				CWarningAlert::Display(kWAStopAlertType,
									kWAOKStyle,
									kStringListID,
									kBadExpirationStringID);
				err = kPGPError_BadParams;
			}
			else
				*expireDays = ( ( expireDate - timeNow ) / 86400 ) + 1;
		}
	}
	else
	{
		*trustLevel = 0;
		if(mExportCheckbox->GetValue())
			*exportable = TRUE;
		else
			*exportable = FALSE;
	}
	return err;
}

	void
CSignDialog::DomainToRegExp(
	char		*domain,
	char		*regExp )
{
	char 		*s = domain,
				*d = regExp;
	
	strcpy( d, "<[^>]+[@.]" );
	d += strlen( d );
	
	for( ; *s; s++ )
	{
		switch( *s )
		{
			case '*':
			case '+':
			case '?':
			case '.':
			case '^':
			case '$':
			case '\\':
			case '[':
			case ']':
			case '-':
				*d++ = '\\';
				*d++ = *s;
				break;
			default:
				*d++ = *s;
				break;
		}
	}
	*d++ = '>';
	*d++ = '$';
	*d++ = '\0';
}

	void
CSignDialog::Sign()
{
	PGPError					err;
	Boolean						success = FALSE;
	PGPBoolean					ksSync,
								split = FALSE;
	CSecureCString256			passphrase;
	PGPByte						*passKey = NULL;
	PGPSize						passKeySize;
	
	Hide();

	err = PGPGetPrefBoolean(gPrefRef,
				kPGPPrefKeyServerSyncOnKeySign, &ksSync);
	pgpAssertNoErr(err);
	
	UDesktop::Deactivate();
	{
		PGPGetPassphraseSettings	signDialogFlags;
		char						promptCStr[256];
		Str255						promptStr;
		
		::GetIndString(	promptStr,
						kStringListID,
						kEnterPassphrasePromptStringID);
		PToCString(promptStr, promptCStr);
		err = PGPClientSigningPassphraseDialog
			(	gPGPContext,
				CPGPKeys::TheApp()->GetKeySet(),
				promptCStr,
				kPGPGetPassphraseOptionsHideFileOptions,
				0,
				mSigner,
				passphrase,
				&signDialogFlags,
				&mSigner );
	}
	
	if( err == kPGPError_KeyUnusableForSignature )
	{
		PGPGetKeyBoolean( mSigner, kPGPKeyPropIsSecretShared, &split );
		if( split )
			err = PGPReconstitutionDialog( mSigner,
				CPGPKeys::TheApp()->GetKeySet(), gTLSContext,
				&passKey, &passKeySize);
	}
	UDesktop::Activate();
	
	if( IsntPGPError( err ) )
	{
		Int32			uIndex;
		PGPUserIDRef	userID;
		Boolean			dupeWarning = FALSE;
		PGPUInt32		trustLevel,
						expirationDays = 0;
		Boolean			exportable,
						domainRestrict = FALSE;
		char			domainRegExp[256];
		
		if( IsntPGPError(
				GetParams( &trustLevel, &exportable, &expirationDays ) ) )
			for(uIndex = mNumUserIDs - 1; uIndex >= 0; uIndex--) 
			{
				if(mUserIDs[uIndex].type == kKey)
				{
					err = PGPGetPrimaryUserID(mUserIDs[uIndex].u.key,
												&userID);
					pgpAssertNoErr(err);
				}
				else if(mUserIDs[uIndex].type == kUserID)
					userID = mUserIDs[uIndex].u.user;
				if( ( trustLevel == 1 ) && exportable )
				{
					Str255	domainPString;
					char	domainCString[256];
					
					mDomainEdit->GetDescriptor( domainPString );
					if( domainPString[0] > 0 )
					{
						PToCString( domainPString, domainCString );
						DomainToRegExp( domainCString, domainRegExp );
						domainRestrict = TRUE;
					}
				}
				CPGPKeys::TheApp()->GetMinimumRandomData();
				err = PGPSignUserID( userID, mSigner,
					PGPOExpiration( gPGPContext, expirationDays ),
					PGPOExportable( gPGPContext, exportable ),
					PGPOSigTrust( gPGPContext, trustLevel,
									kPGPKeyTrust_Complete ),
					split ?
						PGPOPasskeyBuffer( gPGPContext, passKey, passKeySize ):
						PGPOPassphrase( gPGPContext, passphrase ),
					domainRestrict ?
						PGPOSigRegularExpression( gPGPContext, domainRegExp ) :
						PGPONullOption( gPGPContext ),
					PGPOLastOption( gPGPContext ) );
				if( err == kPGPError_DuplicateCert )
				{
					if( !dupeWarning )
					{
						CWarningAlert::Display(kWACautionAlertType,
										kWAOKStyle,
										kStringListID,
										kDuplicateCertID);
						dupeWarning = TRUE;
					}
				}
				else
				{
					pgpAssertNoErr(err);
					if(IsntPGPError(err))
						success = TRUE;
					if(ksSync && exportable)
					{
						err = PGPSendKeyToServer(
							gPGPContext, gTLSContext,
							mUserIDs[uIndex].ownerKey, NULL);
						if(IsPGPError(err) &&
							(err != kPGPError_UserAbort))
							ReportPGPError(err);
					}
				}
			}
		if(success)
		{
			CPGPKeys::TheApp()->CommitDefaultKeyrings();
			BroadcastMessage(kKeyTableResyncMessage, NULL);
		}
	}
	if( IsntNull( passKey ) )
		PGPFreeData( passKey );
}

	void
CSignDialog::ListenToMessage(
	MessageT	inMessage,
	void		*ioParam )
{
	switch(inMessage)
	{
		case kSignButton:
			Sign();
		case kCancelButton:
			delete this;
			break;
		case kAdvancedButton:
			{
				Rect		windBounds;
				Str255		str;
				
				if(mAdvancedMode)
				{
					mSignTypesGroup->Hide();
					mExpireTypesGroup->Hide();
					mExportCheckbox->Show();
					GetMinMaxSize(windBounds);
					ResizeWindowTo(windBounds.right, windBounds.top);
					GetIndString(	str,
									kStringListID,
									kAdvancedOptionsStringID);
				}
				else
				{
					mExportCheckbox->Hide();
					mSignTypesGroup->Show();
					mExpireTypesGroup->Show();
					CalcStandardBounds(windBounds);
					DoSetBounds(windBounds);
					GetIndString(	str,
									kStringListID,
									kFewerOptionsStringID);
				}
				mAdvancedButton->SetDescriptor(str);
				mAdvancedMode = !mAdvancedMode;
			}
			break;
		case kExpirationArrows:
		{
			Int32	newValue = *(Int32 *)ioParam;

			if(newValue < mLastArrowValue)
				mExpirationDate->AdjustValue(kDownAdjust);
			else
				mExpirationDate->AdjustValue(kUpAdjust);
			mLastArrowValue = newValue;
			break;
		}
		default:
			LGADialog::ListenToMessage( inMessage, ioParam );
			break;
	}
}

	void
CSignDialog::FindCommandStatus(
	CommandT	inCommand,
	Boolean		&outEnabled,
	Boolean		&outUsesMark,
	Char16		&outMark,
	Str255		outName)
{
	#pragma unused( inCommand, outUsesMark, outMark, outName )
	
	outEnabled = FALSE;
}

	void
CSignTable::FinishCreateSelf()
{
	CColumnTable::FinishCreateSelf();
}

	Boolean
CSignTable::GetCellDrawData(
	STableCell			inCell,
	ResIDT				&iconID,
	Int16				&indentLevel,
	Str255				data,
	StyleParameter		&style )
{
	KeyTableRef			keyRef;
	PGPUserIDRef		userID;
	TableIndexT			col;
	Uint32				dataSize = sizeof(KeyTableRef);
	
	indentLevel;	style;
	col = inCell.col;
	inCell.col = 1;
	GetCellData( inCell, &keyRef, dataSize );
	switch( col )
	{
		case 1:
		{
			PGPBoolean		isAttributeID;
			
			if( keyRef.type == kKey )
				PGPGetPrimaryUserID( keyRef.u.key, &userID );
			else if( keyRef.type == kUserID )
				userID = keyRef.u.user;
			PGPGetUserIDBoolean( userID, kPGPUserIDPropIsAttribute,
					&isAttributeID );
			if( isAttributeID )
			{
				PGPInt32	attributeType;
				short		strIndex;
				
				PGPGetUserIDNumber( userID, kPGPUserIDPropAttributeType,
					&attributeType );
				if( attributeType == kPGPAttribute_Image )
				{
					strIndex 	= kPhotographStringID;
					iconID		= kPhotoUserIDIconID;
				}
				else
				{
					strIndex 	= kUnknownStringID;
					iconID		= kUnknowUserIDIconID;
				}
				GetIndString( data, kStringListID, strIndex );
			}
			else
			{
				PGPInt32	algorithm;
				size_t		len;
				
				PGPGetKeyNumber( keyRef.ownerKey, kPGPKeyPropAlgID,
					&algorithm );
				if( algorithm == kPGPPublicKeyAlgorithm_DSA )
					iconID = kDHUserIDIconID;
				else
					iconID = kRSAUserIDIconID;

				PGPGetUserIDStringBuffer( userID, kPGPUserIDPropName,
						sizeof(Str255) - 1, (char *)&data[1], &len );
				data[0] = len;
			}
			break;
		}
		case 2:
			CKeyInfoWindow::GetFingerprintString( data, keyRef.ownerKey );
			break;
	}
	return FALSE;
}

