/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: CGroupsWindow.h,v 1.17 1999/03/10 02:34:08 heller Exp $
____________________________________________________________________________*/
#pragma once

#include <LDragAndDrop.h>
#include <LWindow.h>
#include <LListener.h>
#include <LBroadcaster.h>
#include "pgpGroups.h"

#include "CPGPHierarchyTable.h"

const ResIDT	kGroupsWindowID				=	154;
const MessageT	kGroupsWindowClosed			=	'GWcl';

typedef struct GroupTableEntry
{
	Boolean			isTopGroup;
	union
	{
		PGPGroupID		groupID;
		struct
		{
			PGPGroupItem	groupItem;
			PGPGroupID		ownerGroupID;
			PGPKeyRef		cachedKey;
		} item;
	} u;
} GroupTableEntry;

class	CGroupsTable	:	public CPGPHierarchyTable,
							public LCommander,
							public LDragAndDrop
{
public:
	enum { class_ID = 'tGrp' };
						CGroupsTable(LStream *inStream);
	virtual				~CGroupsTable();
	void				FinishCreateSelf();
	
	virtual void		DrawSelf();
	virtual Boolean		ObeyCommand(CommandT inCommand, void* ioParam);	
	virtual void		FindCommandStatus(CommandT inCommand,
									Boolean &outEnabled, Boolean &outUsesMark,
									Char16 &outMark, Str255 outName);

	virtual void		DrawCell(
								const STableCell		&inCell,
								const Rect				&inLocalRect);
	virtual void		ClickCell(
								const STableCell&		inCell,
								const SMouseDownEvent&	inMouseDown);
	virtual void		ClickSelf(
								const SMouseDownEvent	&inMouseDown);
	virtual Boolean		HandleKeyPress(const EventRecord&	inKeyEvent);
	virtual void		HiliteCellActively(
								const STableCell	&inCell,
								Boolean				inHilite);
	virtual void		HiliteCellInactively(
								const STableCell	&inCell,
								Boolean				inHilite);
	void				HiliteCellDrag(const STableCell	&inCell);
	void				SetGroupSet(
								PGPGroupSetRef		groupRef,
								PGPFileSpecRef		groupsFile);
	void				FocusDropArea();
	virtual Boolean		ItemIsAcceptable(
										DragReference	inDragRef,
										ItemReference	inItemRef);
	virtual void		ReceiveDragItem(
										DragReference	inDragRef,
										DragAttributes	inDragAttrs,
										ItemReference	inItemRef,
										Rect			&inItemBounds);
	void				HiliteDropArea(	DragReference	inDragRef);
	void				UnhiliteDropArea(DragReference	inDragRef);
	void				EnterDropArea(	DragReference	inDragRef,
										Boolean			inDragHasLeftSender);
	void				LeaveDropArea(	DragReference	inDragRef);
	void				InsideDropArea(	DragReference	inDragRef);
	
	void				ScrollImageBy(
									Int32		inLeftDelta,
									Int32		inTopDelta,
									Boolean		inRefresh);
	void				InvalidateCaches();
	Boolean				ImportGroupsFromFile( const FSSpec	*fsSpec );
																		
private:
	void				ResyncTable(Boolean collapse, Boolean onlyUnmarked);
	void				RedrawTable();
	void				CollapseGroups(Boolean all);
	void				ExpandGroups();
	void				DrawAddressColumnCell(
								GroupTableEntry		*gtr,
								Rect				cellRect,
								Int16				depth);
	void				DrawValidityColumnCell(
								GroupTableEntry		*gtr,
								Rect				cellRect,
								Int16				depth);
	void				DrawDescriptionColumnCell(
								GroupTableEntry		*gtr,
								Rect				cellRect,
								Int16				depth);
	void				DrawValidity(	Int32		trustValue,
										Rect		cellRect,
										Int16		depth);
	void				UpdateValidityColumn();
	void				RefreshBorder(Rect cellRect);
	Boolean				EditGroup(PGPGroupInfo *groupInfo);
	void				DeleteSelection();
	void				StartDrag(
								const STableCell&		inCell,
								const SMouseDownEvent&	inMouseDown);
	PGPError			AddKeyIDToGroup(
								PGPKeyID			*keyID,
								PGPUInt32			algorithm,
								const STableCell	&groupCell);
	PGPError			AddGroupToGroup(
								PGPGroupID			groupID,
								const STableCell	&groupCell);
	PGPError			AddGroupItemToGroup(
								PGPGroupItem		*item,
								const STableCell	&groupCell);
	void				ResortGroups();
	void				CacheKey(GroupTableEntry *tableEntry);
	void				UpdateFromServer();
	void				RebuildTable();
	void				ShowInfo();
	
	enum
	{
		kMaxColumnTypes		=	3,
		kAddressColumnID	=	0,
		kValidityColumnID,
		kDescriptionColumnID
	};
	
	STableCell				mLastDragCell;
	Boolean					mSendingDrag;
	PGPGroupSetRef			mGroupsRef;
	PGPFileSpecRef			mGroupsFile;
};

class	CGroupsWindow	:	public LWindow,
							public LListener,
							public LBroadcaster
{
public:
	enum { class_ID = 'Gwin' };
								CGroupsWindow();
								CGroupsWindow(LStream *inStream);
								~CGroupsWindow();
	void						FinishCreateSelf();
	virtual void				AttemptClose();
	void						ListenToMessage(MessageT	inMessage,
												void *		ioParam);
	
	void						InvalidateCaches();
private:
	CGroupsTable				*mGroupsTable;
	PGPGroupSetRef				mGroupsRef;
	PGPFileSpecRef				mGroupsFile;
};

