/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: PGPSelectKeysDialog.h,v 1.13 1999/03/10 02:55:51 heller Exp $
____________________________________________________________________________*/

#pragma once 

#include "CPGPModalGrafPortView.h"
#include "CColumnTable.h"
#include "pgpEncode.h"

class CSelectKeysTable;

class CSelectKeysDialog : public CPGPModalGrafPortView
{
public:

	enum				{ class_ID = 'ImpD' };
	
						CSelectKeysDialog(LStream * inStream);
	virtual				~CSelectKeysDialog();
	
	CComboError			Init(	PGPContextRef			inContext,
								PGPSelectKeysSettings	settings,
								PGPPrefRef				inClientPrefs,
								const char *			inPrompt,
								PGPKeySetRef			inFromSet,
								PGPKeySetRef			inValiditySet,
								PGPKeySetRef *			outSelectedSet);
	
	CComboError			GetKeys();
	virtual void		ListenToMessage(MessageT inMessage, void * ioParam);
		
protected:
	PGPBoolean			mSingleSelect;
	virtual void		FinishCreateSelf();
	
private:

	CSelectKeysTable	*mUserIDTable;
	
	void				AdjustButtons();
};

class	CSelectKeysTable	:	public CColumnTable
{
public:
	enum { class_ID = 'ImpT' };
						CSelectKeysTable(LStream *inStream);
	virtual				~CSelectKeysTable();
	virtual Boolean		GetCellDrawData(
								STableCell			inCell,
								ResIDT				&iconID,
								Int16				&indentLevel,
								Str255				data,
								StyleParameter		&style );
	virtual Boolean		DrawCellCustom(
								const STableCell	&inCell,
								const Rect			&inLocalRect,
								Boolean				hilite );
	CComboError			SetTableInfo(PGPContextRef	inContext,
								PGPPrefRef			inClientPrefs,
								PGPKeySetRef		inFromSet,
								PGPKeySetRef		inValiditySet,
								PGPBoolean			inSingleSelect,
								PGPKeySetRef *		outSelectedSet);
								
	CComboError			GetKeys();
protected:
	static PGPError		EventHandler(PGPContextRef context,
								PGPEvent * event, PGPUserValue userValue);	

	PGPKeySetRef		mFromSet;
	PGPKeySetRef *		mSelectedSet;
	PGPKeyIterRef		mKeyIter;
	PixPatHandle		mBarberPixPat;
	PGPBoolean			mShowMarginalValidity;
	PGPBoolean			mMarginalIsInvalid;
	
	CComboError			AddKeysToTable(	PGPKeySetRef	inFromSet );
};

