/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.
	
	$Id: CSelect509Dialog.cp,v 1.7 1999/04/06 10:59:41 wprice Exp $
____________________________________________________________________________*/

#include <URegistrar.h>
#include <PP_Messages.h>
#include <LPushButton.h>

#include "PGPclientLibUtils.h"
#include "PGPclientLibDialogs.h"
#include "pgpMem.h"
#include "pgpErrors.h"
#include "pgpKeys.h"
#include "pgpUtilities.h"
#include "pgpClientLib.h"
#include "pgpClientPrefs.h"

#include "pflPrefTypes.h"

#include "MacErrors.h"
#include "MacCursors.h"
#include "MacQuickdraw.h"
#include "MacStrings.h"
#include "CString.h"

#include "CSelect509Dialog.h"

#define CKERR			if( err.IsError() ) goto done	

const ResIDT	ppob_Select509ID			=	4775;

const ResIDT	icsx_X509Certificate		=	3033;

const PaneIDT	caption_Prompt				=	'cPro';
const PaneIDT	table_Certs					=	't509';
const PaneIDT	button_OK					=	'bOK ';
const PaneIDT	button_Cancel				=	'bCAN';

	static PGPError
RealPGPSelect509Dialog(
	PGPContextRef			context,
	PGPSelectKeysSettings	settings,
	PGPPrefRef				clientPrefsRef,
	const char *			prompt,
	PGPKeySetRef			fromSet,
	PGPKeySetRef			*selectedSet,
	PGPKeyRef				*selectedKey,
	PGPSigRef				*selectedCert )					
{
	CComboError	err;
	DialogRef	skDialog;
	
	RegisterClass_( CSelect509Dialog );
	RegisterClass_( CSelect509Table );
	
	// Create standard Macintosh window and overlay PowerPlant onto it
	skDialog = 
			CPGPModalGrafPortView::CreateDialog( ppob_Select509ID );
	if( IsntNull( skDialog ) )
	{
		CSelect509Dialog *skGrafPortView = nil;

		skGrafPortView =
				(CSelect509Dialog *) GetWRefCon( skDialog );
		pgpAssert( IsntNull( skGrafPortView ) );
		
		err = skGrafPortView->Init( context, settings, clientPrefsRef,
									prompt, fromSet );
		if( err.IsntError() )
		{
			ModalFilterUPP	filterUPP;
			MessageT		dismissMessage;
			short			itemHit = 0;
		
			InitCursor();
			
			SetPort( skDialog );
			ShowWindow( skDialog );
			SelectWindow( skDialog );
	
			skGrafPortView->Refresh();
			
			filterUPP = NewModalFilterProc(
						CPGPModalGrafPortView::ModalFilterProcHandler );
			
			skGrafPortView->SetDismissMessage( msg_Nothing );

			while( itemHit == 0 )
			{
				ModalDialog( filterUPP, &itemHit );
			}
		
			dismissMessage = skGrafPortView->GetDismissMessage();
			if( dismissMessage == msg_OK )
			{
				err = skGrafPortView->GetCert( selectedSet,
										selectedKey, selectedCert );
			}
			else
				err.pgpErr = kPGPError_UserAbort;
		
			DisposeRoutineDescriptor( filterUPP );
		}
		
		delete skGrafPortView;
		DisposeDialog( skDialog );
	}
	else
	{
		err.pgpErr = kPGPError_OutOfMemory;
	}
	
	return err.ConvertToPGPError();
}

	PGPError
PGPSelect509Dialog(
	PGPContextRef			context,
	PGPSelect509Settings	settings,
	const char *			prompt,
	PGPKeySetRef			fromSet,
	PGPKeySetRef			*selectedSet,
	PGPKeyRef				*selectedKey,
	PGPSigRef				*selectedCert )					
{
	PGPError			err;
	PGPclientLibState	state;
	
	PGPValidatePtr( selectedSet );
	PGPValidatePtr( selectedKey );
	PGPValidatePtr( selectedCert );
	*selectedSet	= kInvalidPGPKeySetRef;
	*selectedKey	= kInvalidPGPKeyRef;
	*selectedCert	= kInvalidPGPSigRef;
	PGPValidateParam( IsntNull( context ) );
	PGPValidateParam( IsntNull( fromSet ) );
	
	err = EnterPGPclientLib( context, &state );
	if( IsntPGPError( err ) )
	{
		err = RealPGPSelect509Dialog( context, settings, state.clientPrefsRef,
					prompt, fromSet, selectedSet, selectedKey, selectedCert );
	}
		
	ExitPGPclientLib( &state );
	
	return( err );
}

CSelect509Dialog::CSelect509Dialog(
	LStream *	inStream)
		: CPGPModalGrafPortView(inStream)
{
	m509KeySet = kInvalidPGPKeySetRef;
}

CSelect509Dialog::~CSelect509Dialog()
{
	if( PGPKeySetRefIsValid( m509KeySet ) )
		PGPFreeKeySet( m509KeySet );
}

	CComboError
CSelect509Dialog::Init(
	PGPContextRef			inContext,
	PGPSelect509Settings	settings,
	PGPPrefRef				,
	const char *			inPrompt,
	PGPKeySetRef			inFromSet )
{
	CComboError				err;
	PGPFilterRef			filter = kInvalidPGPFilterRef,
							filter2 = kInvalidPGPFilterRef;
	PGPKeyListRef			keyList = kInvalidPGPKeyListRef;
	PGPKeyIterRef			keyIter = kInvalidPGPKeyIterRef;
	PGPKeyRef				curKey;
	PGPUserIDRef			curUID;
	PGPSigRef				curSig;
	
	if (IsntNull( inPrompt ) )
	{
		FindPaneByID(caption_Prompt)->SetDescriptor(CString(inPrompt));
	}
	// Add items
	err.pgpErr = PGPNewSigBooleanFilter (
				inContext, kPGPSigPropIsX509, TRUE, &filter ); CKERR;
	if( settings & kPGPSelect509CanSignOnly )
	{
		err.pgpErr = PGPNewKeyBooleanFilter (
				inContext, kPGPKeyPropCanSign, TRUE, &filter2 ); CKERR;
		err.pgpErr = PGPIntersectFilters( filter, filter2, &filter ); CKERR;
		filter2 = kInvalidPGPFilterRef;
	}
	if( settings & kPGPSelect509NoSplit )
	{
		err.pgpErr = PGPNewKeyBooleanFilter (
				inContext, kPGPKeyPropIsSecretShared, FALSE, &filter2 );CKERR;
		err.pgpErr = PGPIntersectFilters( filter, filter2, &filter );	CKERR;
		filter2 = kInvalidPGPFilterRef;
	}
	err.pgpErr = PGPFilterKeySet( inFromSet, filter, &m509KeySet ); CKERR;
	err.pgpErr = PGPOrderKeySet( m509KeySet, kPGPUserIDOrdering,
								&keyList );CKERR;
	err.pgpErr = PGPNewKeyIter( keyList, &keyIter );	CKERR;
	while( IsntPGPError( PGPKeyIterNext( keyIter, &curKey ) ) )
	{
		while ( IsntPGPError( PGPKeyIterNextUserID( keyIter, &curUID ) ) )
		{
			while( IsntPGPError( PGPKeyIterNextUIDSig( keyIter, &curSig ) ) )
			{
				PGPBoolean	x509;
				
				PGPGetSigBoolean( curSig, kPGPSigPropIsX509, &x509 );
				if( x509 )
				{
					if( settings & kPGPSelect509CAOnly )
					{
						PGPSigRef	caSigner;
						
						err.pgpErr = PGPGetSigX509CertifierSig( curSig,
									inFromSet, &caSigner );
						if( err.IsError() || ( caSigner != curSig ) )
							continue;
					}
					m509Table->InsertRows( 1, LArray::index_Last,
								&curSig, sizeof(PGPSigRef), TRUE );
				}
			}
		}
	}
done:
	if( PGPFilterRefIsValid( filter ) )
		PGPFreeFilter( filter );
	if( PGPFilterRefIsValid( filter2 ) )
		PGPFreeFilter( filter2 );
	if( PGPKeyIterRefIsValid( keyIter ) )
		PGPFreeKeyIter( keyIter );
	if( PGPKeyListRefIsValid( keyList ) )
		PGPFreeKeyList( keyList );
	return err;
}

	CComboError
CSelect509Dialog::GetCert(
	PGPKeySetRef		*outSelectedSet,
	PGPKeyRef			*outSelectedKey,
	PGPSigRef			*outSelectedCert )
{
	CComboError			err;
	STableCell			cell;
	UInt32				dataSize = sizeof(PGPSigRef);
	
	*outSelectedSet		= kInvalidPGPKeySetRef;
	*outSelectedKey		= kInvalidPGPKeyRef;
	*outSelectedCert	= kInvalidPGPSigRef;
	cell = m509Table->GetFirstSelectedCell();
	if( cell.row > 0 )
	{
		m509Table->GetCellData( cell, outSelectedCert, dataSize );
		*outSelectedKey = PGPGetSigKey( *outSelectedCert );
		*outSelectedSet = m509KeySet;
		m509KeySet = kInvalidPGPKeySetRef;
	}
	
	return err;
}

	void
CSelect509Dialog::FinishCreateSelf()
{
	CPGPModalGrafPortView::FinishCreateSelf();
	
	m509Table = (CSelect509Table *) FindPaneByID( table_Certs );
	pgpAssert( IsntNull( m509Table ) );
	
	m509Table->AddListener(this);
	SetLatentSub( m509Table );
}

	void
CSelect509Dialog::ListenToMessage(
	MessageT	inMessage,
	void *		ioParam)
{
	STableCell	theCell(0, 0);

	switch (inMessage)
	{
		case coltable_DoubleClick:
			( (LPushButton *)FindPaneByID(button_OK) )->
				SimulateHotSpotClick( kControlButtonPart );
			break;
		case coltable_SelectChange:
			if( m509Table->GetNextSelectedCell( theCell ) )
				FindPaneByID(button_OK)->Enable();
			else
				FindPaneByID(button_OK)->Disable();
			break;
		default:
			CPGPModalGrafPortView::ListenToMessage( inMessage, ioParam );
			break;
	}
}

	Boolean
CSelect509Table::GetCellDrawData(
	STableCell			inCell,
	ResIDT				&iconID,
	Int16				&indentLevel,
	Str255				data,
	StyleParameter		& )
{
	PGPError			err;
	PGPSigRef			cert;
	UInt32				len = sizeof(PGPSigRef);
	TableIndexT			col;
	char				cstr[256];
	PGPSize				stringLen;
	
	indentLevel;
	col = inCell.col;
	inCell.col = 1;
	GetCellData( inCell, &cert, len );
	switch( col )
	{
		case 1:		// Name
			iconID = icsx_X509Certificate;
			err = PGPGetSigPropertyBuffer( cert, kPGPSigPropX509LongName,
										sizeof(cstr), &cstr[0], &stringLen );
			if( IsntPGPError( err ) )
			{
				cstr[stringLen] = 0;
				CToPString( cstr, data );
			}
			break;
	}
	return FALSE;
}

