/*____________________________________________________________________________
	TranslatorUtils.h
	
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: TranslatorUtils.h,v 1.16 1999/04/26 09:41:28 heller Exp $
____________________________________________________________________________*/
#pragma once

#include "EudoraTypes.h"

#include "pgpTypes.h"

#include "CComboError.h"

#include "pgpEncode.h"
#include "PGPclientLib.h"

#ifdef __cplusplus
extern "C" {
#endif




/* we use this to see if we've already processed a message
when Eudora calls CanTranslate file */
const uchar	kPGPAlreadyProcessedParamName[]		= "\pPGPProcessed";
const uchar	kPGPAlreadyProcessedParamValue[]	= "\pyes";

			
			
long	SignatureDataToEudoraResult( PGPEventSignatureData const *sigData );


OSErr	ParseFileForMIMEType( const FSSpec *spec,
			emsMIMETypeHandle *typeHandlePtr );




OSErr	CopyFileToFileRef( PGPMemoryMgrRef	memoryMgr,
			const FSSpec * fileToCopy, short destFileRef );

					
					
#if PGP_DEBUG
	void	DebugCopyToRAMDisk( PGPMemoryMgrRef memoryMgr, const FSSpec *spec,
					ConstStr255Param name );
#else
	#define DebugCopyToRAMDisk( memoryMgr, spec, name )
#endif



OSErr	FSpReadFileIntoBuffer( PGPContextRef context, const FSSpec * spec,
			void ** bufferOut, ulong *	 bufferSizeOut );


void			MyGetIndCString( ushort whichString, char *theString );
StringHandle	GetIndStringHandle( ushort whichString );


long			CComboErrorToEudoraError( CComboError &err );



OSErr	EliminateMIMEHeader( PGPContextRef context, const FSSpec *spec );



CComboError	GetRecipientList( PGPContextRef context,
				PGPtlsContextRef tlsContext,
				emsHeaderDataP header,
				PGPKeySetRef allKeys,
				Boolean isPGPMime,
				PGPKeySetRef * keySet,
				PGPRecipientSettings *	settings,
				PGPKeySetRef *	keyToAdd);




#ifdef __cplusplus
}
#endif
