/*____________________________________________________________________________
	CSignTranslator.cp
	
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: CSignTranslator.cp,v 1.39 1999/04/26 09:40:09 heller Exp $
____________________________________________________________________________*/

#include <string.h>
#include <TextUtils.h>

#include "pgpMem.h"


#include "pgpErrors.h"

#include "MacStrings.h"
#include "MacFiles.h"

#include "PGPUserInterface.h"
#include "MyMIMEUtils.h"
#include "TranslatorIDs.h"
#include "PluginLibUtils.h"
#include "CPGPFree.h"
#include "CFSCloser.h"
#include "TranslatorUtils.h"
#include "PassphraseCache.h"
#include "TranslatorStrings.h"
#include "PGPKeys.h"
#include "pgpHash.h"
#include "pgpEncode.h"
#include "pgpVersionHeader.h"
#include "TranslatorPrefs.h"
#include "CSecureMemory.h"

#include "CSignTranslator.h"





CSignTranslator::CSignTranslator(
	PGPContextRef		context,
	PGPtlsContextRef	tlsContext,
	emsProgress			progress,
	CipherOutputType	outputType )
	: CTranslator( context, tlsContext, progress)
{
	mOutputType	= outputType;
}



#pragma global_optimizer on



	PluginError
CSignTranslator::TranslateFile(
	emsTranslatorP 		trans,
	emsDataFileP 		inFile,
    emsDataFileP 		outFile,
    emsResultStatusP 	transStatus)
{
	CComboError		err;
	PluginError		emsrErr	= EMSR_OK;
	Boolean			usePGPMime	= ( mOutputType == kUsePGPMIME );
	
	(void) trans;
	(void) transStatus;
	
	if ( ! usePGPMime )
	{
		// use PGPMIME if we're processing anything other than text
		if ( ! MatchMIMEType( inFile->mimeInfo, "\ptext", "\pplain" ) )
		{
			usePGPMime	= true;
		}
	}
	
	const Boolean		useTextOutput	= true;
	FSSpec				signatureSpec;
	
	if ( err.IsntError() )
	{
		PGPKeyRef			signingKey	= kInvalidPGPKeyRef;
		PGPContextRef		c	= mContext;
		char				mimeDelimiter[ kPGPMimeSeparatorSize ];
		PGPPassBufferRef	passBuffer;
	
		DebugCopyToRAMDisk( PGPGetContextMemoryMgr( mContext ), &inFile->file,
					"\pSignClearText" );
		
		if ( (! usePGPMime ) &&
			MatchMIMEType( inFile->mimeInfo, "\ptext", "\pplain" ) )
		{
			// only eliminate it for plain text, not text/enriched or other
			err.err	= EliminateMIMEHeader( c, &inFile->file );
		}
		
		if ( err.IsntError()  )
		{
			err.err	= FSpGetUniqueSpec( &outFile->file, &signatureSpec );
		}
	
		
		err	= GetSigningPassBuffer( &passBuffer, &signingKey );
		if ( err.IsntError()  )
		{
			PGPOptionListRef	optionList	= kInvalidPGPOptionListRef;
			EncryptSignEventHandlerData	data(this);
			PGPSize				mimeBodyOffset;
			char				comment[ 256 ];
			Boolean	signatureOnly	= usePGPMime;
		
			PrefGetComment( comment );
		
			// all these options are the same, regardless of whether it's
			// PGP/MIME or clear signed
			err.pgpErr	= PGPBuildOptionList( c, &optionList,
					PGPOInputFileFSSpec( c, &inFile->file ),
					PGPOOutputFileFSSpec( c, &outFile->file ),
					PGPOSignWithKey( c, signingKey,
						PGPOPassBuffer(c, passBuffer),
						PGPOLastOption(c) ),
					PGPOLocalEncoding( c, kPGPLocalEncoding_None ),
					PGPOArmorOutput(c, TRUE),
					PGPOOutputLineEndType( c, kPGPLineEnd_CRLF),
					PGPOEventHandler( c, sPGPEncodeEventHandler, &data ),
					PGPOSendNullEvents( c, TRUE ),
					PGPOClearSign(c, TRUE),
					PGPOVersionString( c, pgpVersionHeaderString ),
					PGPOCommentString( c, comment ),
					PGPOLastOption(c)
					);
			
			if ( err.IsntError() )
			{
				err.pgpErr = PGPGuaranteeMinimumEntropy( c );
			}

			if ( err.IsntError() )
			{
				if ( usePGPMime )
				{
					err.err	= PGPEncode( c,
							optionList,
							PGPOPGPMIMEEncoding( c, TRUE,
								&mimeBodyOffset, mimeDelimiter ),
							PGPOOmitMIMEVersion( c, TRUE),
							PGPOLastOption(c) );
				}
				else
				{
					/* clear sign */
					err.err	= PGPEncode( c, optionList, PGPOLastOption(c) );
				}
			}
			
			if( err.IsntError() )
			{
				RememberSigningPassBuffer( passBuffer, signingKey );
				
				// remember it for encryption as well (but not vice versa)
				RememberDecryptionPassBuffer( passBuffer, signingKey );
			}
				
			PGPFreePassBuffer( passBuffer );

			if ( optionList != kInvalidPGPOptionListRef )
				PGPFreeOptionList( optionList );
		}
		
		DebugCopyToRAMDisk( PGPGetContextMemoryMgr( mContext ), &outFile->file,
					"\pSignedOut" );
		
		// finish up by creating appropriate MIME types and parameters
		// and by putting output data into appropriate format
		if ( err.IsntError() )
		{
			if ( ! usePGPMime )
			{
				// signatureSpec contains the original data + the signature
				err.err	= FSpExists( &outFile->file ) ? kPGPError_NoErr :
							kPGPError_FileNotFound;
			}
			
			// this information already in output, but Eudora forces us to
			// put it in a Eudora-defined data structure
			if ( err.IsntError() )
			{
				if ( usePGPMime )
				{
					err.err	= BuildSignedPGPMIMEType( &outFile->mimeInfo,
							mimeDelimiter );
				}
				else
				{
					err.err	= CreateMIMEType( "\ptext", "\pplain", &outFile->mimeInfo );
				}

				if ( err.IsntError() )
				{
					err.err	= AddMIMEParam( outFile->mimeInfo,
							kPGPAlreadyProcessedParamName,
							kPGPAlreadyProcessedParamValue);
				}
			}
		}
		
		DebugCopyToRAMDisk( PGPGetContextMemoryMgr( mContext ), &outFile->file,
					"\pSignFinalOut" );
		
		if ( err.IsError() )
		{
			gSigningPassphraseCache->Forget();
			
			ReportError( err );
		}
	}
	
					
	return( CComboErrorToEudoraError( err ) );
}



	void
CSignTranslator::GetErrorString(
	CComboError	err,
	StringPtr	msg )
{
	if ( err.HavePGPError() )
	{
		switch( err.pgpErr )
		{
			default:
				CTranslator::GetErrorString( err, msg );
				break;
			
			case kPGPError_SecretKeyNotFound:
			case kPGPError_AdditionalRecipientRequestKeyNotFound:
				GetIndString( msg,
					kTranslatorErrorStringsResID, kNoDefaultKeyStrIndex );
				break;
		}
	}
	else
	{
		CTranslator::GetErrorString( err, msg );
	}
}









