/* ======================================================================

	Functions to manage string buffers

	Filename:			BufType.h
	Last Edited:		March 7, 1997
	Authors:			Scott Manjourides, Laurence Lundblade, Bob Fronabarger
	Copyright:			1995, 1996 QUALCOMM Inc.
	Technical support:	<emsapi-info@qualcomm.com>
*/

#ifndef BUFTYPE_H
#define BUFTYPE_H

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

typedef struct {
	Handle			bufHandle;
	unsigned long	len;
	unsigned long	pos;
} BufType, *BufTypePtr, **BufTypeHandle;

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

BufTypeHandle MakeSize_Buf(unsigned long n);
BufTypeHandle Make_Buf();
Boolean		  IsEmpty_Buf(BufTypeHandle bh);
unsigned long BufLen_Buf(BufTypeHandle bh); /* Number of valid chars in buffer. Always < BufSize_Buf() */
Handle		  GetBuf_Buf(BufTypeHandle bh);
Ptr			  GetEnd_Buf(BufTypeHandle bh);
unsigned long BufSize_Buf(BufTypeHandle bh); /* The size of the buffer -- used or not */
Boolean		  SetLen_Buf(BufTypeHandle bh, unsigned long n);

unsigned long BufNCat_Buf(BufTypeHandle dst, BufTypeHandle src, unsigned long n);
unsigned long BufIns_Buf(BufTypeHandle b1, BufTypeHandle b2);
unsigned long BufNIns_Buf(BufTypeHandle b1, BufTypeHandle b2, unsigned long n);
unsigned long StrCpy_Buf(BufTypeHandle dst, const StringPtr src);
unsigned long StrCat_Buf(BufTypeHandle dst, const char *src);
unsigned long HandleCat_Buf(BufTypeHandle dst, const Handle src);

unsigned long PosLen_Buf(BufTypeHandle bh); /* Number of valid chars, starting at current position */
void		  IncPos_Buf(BufTypeHandle bh, unsigned long n);
void		  DelPos_Buf(BufTypeHandle bh);
void		  ResetPos_Buf(BufTypeHandle bh);
Ptr			  GetPos_Buf(BufTypeHandle bh);

void		  Delete_Buf(BufTypeHandle bh);
void		  Free_Buf(BufTypeHandle bh);
void		  Clear_Buf(BufTypeHandle bh);
void		  EmptyBuf_Buf(BufTypeHandle bh);
unsigned long CompleteCount_Buf(BufTypeHandle src, BufTypeHandle find, unsigned long n);
unsigned long SkipCount_Buf(BufTypeHandle buf, BufTypeHandle find);
Boolean       Lock_Buf(BufTypeHandle bh);
void          Unlock_Buf(BufTypeHandle bh);

#endif
