/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	$Id: PGPnetOT.cp,v 1.16 1999/05/14 07:23:17 wprice Exp $
____________________________________________________________________________*/
#include "PGPnetOT.h"
#include "PGPnetService.h"
#include "pgpIKE.h"
#include "pgpMem.h"

	static PGPBoolean
IsTCPStackLoaded(void)
{
	InetInterfaceInfo info;

	return ( OTInetGetInterfaceInfo(&info, 0) == noErr );
}

	static pascal void
OTNotifyProc(
	void *				context,
	OTEventCode			code,
	OTResult			result,
	void *				cookie )
{
	context;
	result;
	cookie;
	switch( code )
	{
		case kOTSyncIdleEvent:
			EventIdle();
			break;
		case kOTProviderWillClose:
		case kOTProviderIsClosed:
			PNCloseEndpoint();
			break;
		case T_DATA:
			// A packet awaits our attention
			break;
		default:
			break;
	}
}

	PGPBoolean
PNOpenEndpoint(
	PGPBoolean	force )
{
	OSStatus			err = kPGPError_NoErr;
	PGPBoolean			result = FALSE;

	if( ( gEndpoint == kOTInvalidEndpointRef ) &&
		( force || IsTCPStackLoaded() ) )
	{
		InetInterfaceInfo info;

		gEndpoint = OTOpenEndpoint( OTCreateConfiguration(kUDPName),
										0, NULL, &err );
		if( IsntPGPError( err ) )
			err = OTSetBlocking( gEndpoint );
		if( IsntPGPError( err ) )
			err = OTSetSynchronous( gEndpoint );
		if( IsntPGPError( err ) )
			err = OTInstallNotifier(	gEndpoint, OTNotifyProc, NULL );
		if( IsntPGPError( err ) )
			err = OTUseSyncIdleEvents( gEndpoint, true );
		if( IsntPGPError( err ) )
			err = OTInetGetInterfaceInfo( &info, 0 );
		if( IsntPGPError( err ) )
		{
			gLocalIP = info.fAddress;
			if( gModuleStream != kOTInvalidStreamRef )
			{
				PGPnetModuleMsg	msg;
				OSStatus		status;
				
				msg.type					= kPGPnetModuleBroadcastMsg;
				if( info.fBroadcastAddr != 0 )
					msg.broadcast.addr		=	info.fBroadcastAddr;
				else
					msg.broadcast.addr		=	info.fAddress | ~info.fNetmask;
				status = PGPnetModuleSendMessage( gModuleStream, &msg,
							sizeof(PGPnetModuleBroadcastMsg) );
				LogIfOSStatus( status );
			}
		}
		if( IsntPGPError( err ) )
		{
			InetAddress		otAddress;
			TBind			theBind;
			
			OTInitInetAddress( &otAddress, kPGPike_CommonPort,
				kOTAnyInetAddress );
			theBind.addr.len	= sizeof(InetAddress);
			theBind.addr.buf	= (PGPByte *) &otAddress;
			theBind.addr.maxlen	= sizeof(otAddress);
			theBind.qlen		= 1;
			err = OTBind( gEndpoint, &theBind, &theBind);
		}
		if( IsntPGPError( err ) )
			result = TRUE;
		else
		{
			if( err == kOTAddressBusyErr )
			{
				LogServiceError( kPGPnetSrvcError_IKEPortInUse );
				gGo = FALSE;
			}
			else
				LogIfPGPError( err );
			PNCloseEndpoint();
		}
	}
	else if( gEndpoint != kOTInvalidEndpointRef )
		result = TRUE;
	pgpAssertNoErr( err );
	return result;
}

	void
PNCloseEndpoint()
{
	if( gEndpoint != kOTInvalidEndpointRef )
	{
		OTUnbind( gEndpoint );
		OTCloseProvider( gEndpoint );
		gEndpoint	= kOTInvalidEndpointRef;
		gLocalIP	= 0;
	}
}

	PGPBoolean
PNReadPacket()
{
	size_t		numBytes;
	OSStatus	err = noErr;
	OTResult	result;
	PGPBoolean	gotPacket = FALSE;

	if( PNOpenEndpoint( FALSE ) )
	{
		result = OTCountDataBytes( gEndpoint, &numBytes );
		if ( ( result == kOTNoError ) && ( numBytes > 0 ) )
		{
			TUnitData		tdu;
			InetAddress		theAddress;
			OTFlags			flags;

			OTInitInetAddress( &theAddress, kPGPike_CommonPort,
									kOTAnyInetAddress );
			tdu.addr.maxlen		= sizeof(InetAddress);
			tdu.addr.buf		= (UInt8 *) &theAddress;
			tdu.opt.maxlen		= 0;
			tdu.opt.buf			= NULL;
			tdu.udata.maxlen	= kMaximumUDPPacketSize;
			tdu.udata.buf		= gInPacket;
			
			err = OTRcvUData(	gEndpoint, &tdu, &flags);	CKERR;
			if( err == kOTNoError )
			{
				gInPacketAddr		= theAddress.fHost;
				gInPacketLen		= tdu.udata.len;
				gotPacket = TRUE;
			}
			else if( err == kOTLookErr )
			{
				err = OTRcvUDErr( gEndpoint, NULL );
				switch (err)
				{
					default:
						break;
				}
			}
			else
			{
				pgpAssertNoErr( err );
			}
		}
		else if( result == kOTLookErr )
		{
			result = OTRcvUDErr( gEndpoint, NULL );
			switch (result)
			{
				default:
					break;
			}
		}
	}
done:
	pgpAssertNoErr( err );
	return gotPacket;
}

	void
PNSendPacket(
	PGPUInt32		destIP,
	PGPByte *		data,
	PGPSize			len )
{
	OSStatus		err = kPGPError_NoErr;
	TUnitData		tdu;
	InetAddress		theAddress;
	
	if( PNOpenEndpoint( FALSE ) )
	{
		OTInitInetAddress( &theAddress, kPGPike_CommonPort, destIP );
		tdu.addr.len			= sizeof(InetAddress);
		tdu.addr.buf			= (UInt8 *) &theAddress;
		tdu.opt.len				= 0;
		tdu.opt.buf				= NULL;
		tdu.udata.len			= len;
		tdu.udata.buf			= (PGPByte *) data;
		err = OTSndUData( gEndpoint, &tdu );
		if( err == kOTLookErr )
		{
			err = OTRcvUDErr( gEndpoint, NULL );
			switch (err)
			{
				default:
					break;
			}
		}
		else
		{
			pgpAssertNoErr( err );
		}
	}
}

