/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CGeneralPanel.cp,v 1.13 1999/04/23 07:59:52 wprice Exp $
____________________________________________________________________________*/

#include <LRadioButton.h>
#include <LCheckBox.h>
#include <LEditText.h>
#include <LLittleArrows.h>

#include "CGeneralPanel.h"
#include "pflPrefTypes.h"
#include "CPGPnet.h"
#include "pgpNetPrefs.h"
#include "CGADurationEditField.h"

const PaneIDT	checkbox_AllowComm			=	'xUnc';
const PaneIDT	checkbox_AttemptSecureComm	=	'xSec';
const PaneIDT	checkbox_Cache				=	'xCac';
const PaneIDT	duration_IKE				=	'eIDu';
const PaneIDT	duration_IPSEC				=	'eSDu';
const PaneIDT	checkbox_IKEDuration		=	'xIDu';
const PaneIDT	checkbox_IPSECDuration		=	'xSDu';
const PaneIDT	checkbox_IKEMB				=	'xIMB';
const PaneIDT	checkbox_IPSECMB			=	'xSMB';
const PaneIDT	checkbox_RequireValidKey	=	'xVal';
const PaneIDT	edit_IKEMB					=	'eIMB';
const PaneIDT	edit_IPSECMB				=	'eSMB';
const PaneIDT	arrows_IKEDuration			=	'lIDu';
const PaneIDT	arrows_IPSECDuration		=	'lSDu';

	void
CGeneralPanel::FinishCreateSelf()
{
	LLittleArrows		*arrowsObj;

	// Listen to buttons
	((LCheckBox *) FindPaneByID(checkbox_AllowComm))->AddListener(this);
	
	arrowsObj = (LLittleArrows *) FindPaneByID(arrows_IKEDuration);
	mLastArrowIKE =  arrowsObj->GetValue();
	arrowsObj->AddListener(this);
	arrowsObj = (LLittleArrows *) FindPaneByID(arrows_IPSECDuration);
	mLastArrowIPSEC =  arrowsObj->GetValue();
	arrowsObj->AddListener(this);
	
	Load( NULL );
}

	void
CGeneralPanel::ListenToMessage(
	MessageT				inMessage,
	void *					ioParam)
{
	Int32					newValue;
	CGADurationEditField	*durationObj;

	switch (inMessage)
	{
		case checkbox_AllowComm:
			if (((LCheckBox *) FindPaneByID(checkbox_AllowComm))->
					GetValue() == Button_On)
			{
				FindPaneByID(checkbox_AttemptSecureComm)->Enable();
			}
			else
			{
				FindPaneByID(checkbox_AttemptSecureComm)->Disable();
			}
			break;
		case arrows_IKEDuration:
			durationObj = (CGADurationEditField *)
							FindPaneByID( duration_IKE );
			newValue = *(Int32 *)ioParam;
			if( newValue < mLastArrowIKE )
				durationObj->AdjustValue(kDownAdjust);
			else
				durationObj->AdjustValue(kUpAdjust);
			mLastArrowIKE = newValue;
			break;
		case arrows_IPSECDuration:
			durationObj = (CGADurationEditField *)
							FindPaneByID( duration_IPSEC );
			newValue = *(Int32 *)ioParam;
			if( newValue < mLastArrowIPSEC )
				durationObj->AdjustValue(kDownAdjust);
			else
				durationObj->AdjustValue(kUpAdjust);
			mLastArrowIPSEC = newValue;
			break;
	}
}

	void
CGeneralPanel::Load(
	void * )
{
	PGPBoolean				boolPref;
	PGPUInt32				numPref;
	CGADurationEditField	*durationObj;
	
	PGPGetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefAllowUnconfiguredHosts, &boolPref );
	((LCheckBox *) FindPaneByID(checkbox_AllowComm))->SetValue( boolPref );
	PGPGetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefRequireValidKey, &boolPref );
	((LCheckBox *) FindPaneByID(checkbox_RequireValidKey))->SetValue( boolPref );
	PGPGetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefRequireSecure, &boolPref );
	((LCheckBox *) FindPaneByID(checkbox_AttemptSecureComm))->
		SetValue( boolPref );
	PGPGetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefEnablePassphraseCache, &boolPref );
	((LCheckBox *) FindPaneByID(checkbox_Cache))->SetValue( boolPref );

	PGPGetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefEnableIKETimeExpiration, &boolPref );
	((LCheckBox *) FindPaneByID(checkbox_IKEDuration))->SetValue( boolPref );
	PGPGetPrefNumber( CPGPnet::GetNetPrefs(),
		kPGPNetPrefIKETimeExpiration, &numPref );
	durationObj = (CGADurationEditField *) FindPaneByID( duration_IKE );
	durationObj->SetDurationType( kLengthDurationType );
	durationObj->SetDurationValue( numPref );
	durationObj->Refresh();
	
	PGPGetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefEnableIPSECTimeExpiration, &boolPref );
	((LCheckBox *) FindPaneByID(checkbox_IPSECDuration))->SetValue( boolPref );
	PGPGetPrefNumber( CPGPnet::GetNetPrefs(),
		kPGPNetPrefIPSECTimeExpiration, &numPref );
	durationObj = (CGADurationEditField *) FindPaneByID( duration_IPSEC );
	durationObj->SetDurationType( kLengthDurationType );
	durationObj->SetDurationValue( numPref );
	durationObj->Refresh();
	
	PGPGetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefEnableIKEKByteExpiration, &boolPref );
	((LCheckBox *) FindPaneByID(checkbox_IKEMB))->SetValue( boolPref );
	PGPGetPrefNumber( CPGPnet::GetNetPrefs(),
		kPGPNetPrefIKEKByteExpiration, &numPref );
	((LEditText *) FindPaneByID(edit_IKEMB))->SetValue( numPref / 1024 );
	
	PGPGetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefEnableIPSECKByteExpiration, &boolPref );
	((LCheckBox *) FindPaneByID(checkbox_IPSECMB))->SetValue( boolPref );
	PGPGetPrefNumber( CPGPnet::GetNetPrefs(),
		kPGPNetPrefIPSECKByteExpiration, &numPref );
	((LEditText *) FindPaneByID(edit_IPSECMB))->SetValue( numPref / 1024 );
}

	void
CGeneralPanel::Save(
	void * )
{
	PGPBoolean		boolPref;
	PGPUInt32		numPref;
	
	boolPref = ((LCheckBox *) FindPaneByID(checkbox_AllowComm))->GetValue();
	PGPSetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefAllowUnconfiguredHosts, boolPref );
	boolPref = ((LCheckBox *) FindPaneByID(checkbox_RequireValidKey))->GetValue();
	PGPSetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefRequireValidKey, boolPref );
	boolPref = ((LCheckBox *) FindPaneByID(checkbox_AttemptSecureComm))->
		GetValue();
	PGPSetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefRequireSecure, boolPref );
	boolPref = ((LCheckBox *) FindPaneByID(checkbox_Cache))->GetValue();
	PGPSetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefEnablePassphraseCache, boolPref );
	
	boolPref = ((LCheckBox *) FindPaneByID(checkbox_IKEDuration))->GetValue();
	PGPSetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefEnableIKETimeExpiration, boolPref );
	numPref = ((CGADurationEditField *)
		FindPaneByID( duration_IKE ) )->GetDurationValue();
	if( numPref < 60 )
		numPref = 60;
	PGPSetPrefNumber( CPGPnet::GetNetPrefs(), kPGPNetPrefIKETimeExpiration, numPref);

	boolPref = ((LCheckBox *) FindPaneByID(checkbox_IPSECDuration))->GetValue();
	PGPSetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefEnableIPSECTimeExpiration, boolPref );
	numPref = ((CGADurationEditField *)
		FindPaneByID( duration_IPSEC ) )->GetDurationValue();
	if( numPref < 60 )
		numPref = 60;
	PGPSetPrefNumber( CPGPnet::GetNetPrefs(),
		kPGPNetPrefIPSECTimeExpiration, numPref);
		
	boolPref = ((LCheckBox *) FindPaneByID(checkbox_IKEMB))->GetValue();
	PGPSetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefEnableIKEKByteExpiration, boolPref );
	numPref = ((LEditText *) FindPaneByID(edit_IKEMB))->GetValue();
	if( numPref < 4 )
		numPref = 4;
	if( numPref > 4095 )
		numPref = 4095;
	numPref *= 1024;
	PGPSetPrefNumber( CPGPnet::GetNetPrefs(),
		kPGPNetPrefIKEKByteExpiration, numPref);

	boolPref = ((LCheckBox *) FindPaneByID(checkbox_IPSECMB))->GetValue();
	PGPSetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefEnableIPSECKByteExpiration, boolPref );
	numPref = ((LEditText *) FindPaneByID(edit_IPSECMB))->GetValue();
	if( numPref < 4 )
		numPref = 4;
	if( numPref > 4095 )
		numPref = 4095;
	numPref *= 1024;
	PGPSetPrefNumber( CPGPnet::GetNetPrefs(),
		kPGPNetPrefIPSECKByteExpiration, numPref);
}

