/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	$Id: CAuthenticationPanel.h,v 1.9 1999/02/20 10:49:17 wprice Exp $
____________________________________________________________________________*/
#pragma once 

#include <LListener.h>
#include "CPanel.h"
#include "StPGPRefs.h"

class CAuthenticationPanel	:	public CPanel,
								public LListener
{
public:
	enum { class_ID = 'pAth' };

					CAuthenticationPanel(LStream * inStream);
	virtual			~CAuthenticationPanel();
					
	virtual void	ListenToMessage(MessageT inMessage, void * ioParam);
								
	virtual void	Load(void * inParam);
	virtual void	Save(void * inParam);
						
protected:
	PGPKeyRef		mPGPAuthKey;
	StPGPKeySetRef	mPGPKeySet;

	PGPKeyRef		m509AuthKey;
	PGPSigRef		m509AuthCert;
	StPGPKeySetRef	m509KeySet;
	
	virtual void	FinishCreateSelf();
	
	PGPKeySetRef	PGPAuthenticationKeyFilter(PGPKeySetRef inAllKeys) const;
	
	LPushButton *	mClearKey,
				*	mClearCert;
};

