/*____________________________________________________________________________
	Copyright (C) 1996-1998 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CDrive.h,v 1.8 1999/03/10 02:32:54 heller Exp $
____________________________________________________________________________*/

#pragma once

#include <stddef.h>
#include <Timer.h>

#include "CipherProc.h"
	
#include "CipherContext.h"

#include "PGPDisk.h"

#include "MacDriverUtils.h"
#include "MacFiles.h"


#include "TunerStruct.h"
	
#include "CipherProcGlue.h"

typedef union XIOPB
	{
	ParamBlockRec	pb;
	XIOParam		xpb;
	} XIOPB;
		



#define CDRIVE_WATCHDOG	1

class	CBlindWriteQueue;
struct	AddDriveStruct;
class	CCloseQueue;
class	CChangeModDateQueue;

// yes, include it inside this class
#include "CMacQueue.h"

class CDrive
	{
public:
	typedef struct InitInfo
		{
		const AddDriveStruct *	info;
		
		void *				pbArray;
		ushort				numPBs;
		Boolean				shouldBreakUpRequests;
		
		CipherProcRef		cipherProcRef;
		} InitInfo;
		
		
protected:


#if INSTRUMENT
	UnsignedWide	mStartTime;
	UnsignedWide	mIOStartTime;
	UnsignedWide	mIOFinishTime;
	UnsignedWide	mCipherTime;
#endif


	typedef ulong	PosOffset;

	enum IODirection	{ kReadDirection, kWriteDirection };
	
	
	
#if CDRIVE_WATCHDOG
	typedef struct
		{
		TMTask					tmTask;
		CDrive *				thisObject;
		} WatchdogTMTask;
	
	struct
		{
		WatchdogTMTask	task;
		DeferredTask *	watchTask;
		Boolean			shouldUseWatchdog;
		Boolean			installed;
		} mWatchdog;
	
	void			WatchdogTask( void );
	static pascal void		sWatchdogTMTask( void );
	void			InstallWatchdog( DeferredTask *watchTask );
	void			RemoveWatchdog( void );
#endif
	
	typedef struct MyPB
		{
		#if PGP_DEBUG
		enum { kMagic	= 'MyPB' };
		OSType			magic;
		#endif
	
		ulong			startBlockOnSelf;
		QElem			ioQElem;
		QElem			processingQElem;
		
		const void *	src;
		CDrive *		theDrive;
	
		XIOPB			ioPB;
		
		enum { kMaxRetryCount = 10 };
		struct
			{
			ushort		count;
			ulong		startBlock;
			TMTask		tmTask;
			} retry;
		} MyPB;
	#if PGP_DEBUG
	inline void SetPBMagic( MyPB *myPB ) const
			{ myPB->magic	= MyPB::kMagic;	}
	#else
	inline void SetPBMagic( const MyPB * ) const	{}
	#endif
	
	void			RetryTMTask( MyPB *myPB );
	static void		sRetryTMTask( void );
	void			ScheduleRetry( MyPB *myPB );

	MyPB *	ProcessingQueueElemToMyPB( QElem *elem )
					{ return( (MyPB *) ( ((Ptr)elem) -
							offsetof( MyPB, processingQElem )) ); }


	UInt32		GetPBStartBlock( const MyPB  *myPB )
					{ return( ::GetPBStartBlock( &myPB->ioPB.pb ) ); }
	UInt32		GetPBNumBlocks( const MyPB  *myPB )
					{ return( ::GetPBNumBlocks( &myPB->ioPB.pb ) ); }
	
	#if PGP_DEBUG
	enum { kDriveMagic	= (OSType)'DRIV' };
	OSType	mMagic;
	#endif
	
	BWIcon				mMediaIcon;
	BWIcon				mPhysicalIcon;
	Str255				mVolumeString;	// caution: MUST be after
										// mPhysicalIcon
	
	const FlagsDrvQEl *	mMyDQE;
	const VCB *			mVCB;
	short				mFileRefNum;
	Boolean				mHasBeenMounted;
	Boolean				mWriteProtected;
	ProcessSerialNumber	mUnmountedAppPSN;
	

	short				mBaseDriveNumber;
	short				mBaseDriverRefNum;
	Str255				mVolumeName;	// when mounted
	
	const VCB *			mBaseDriveVCB;
	Boolean				mBaseDriveIsEjectable;
	Boolean				BaseDriveIsAvailable( void );
	
	Boolean				mReinsertNotificationPending;
	void				NotifyUserToReinsert( ConstStr255Param msg );
	void				NMProc( NMRec *nmRec );
	static pascal void	sNMProc( NMRec *nmRec );
	
	CipherProcRef		mCipherProcRef;
	
	IODirection			mIODirection;
	ParamBlockRec *		mClientPB;
	OSErr				mResultErr;
	DCtlEntry *			mDCE;
	ulong				mLastAccessTime;
	ulong				mLastWriteTime;
	ulong				mLastFileModDateUpdate;
	
	const DiskExtent *	mExtents;
	PGPUInt32			mNumExtents;
	
	ushort				mWhichCipherContextValid;
	CipherContext 		mCipherContext[ 2 ];
	
	MyPB *				mPBArray;
	ushort				mNumPBs;
	
	CMacQueue			mProcessingQueue;
	CMacQueue			mIOQueue;
	Boolean				mDecryptLock;
	Boolean				mEncryptLock;

#if ALLOW_VM_PAGING
	Boolean				mVirtualMemoryIsOn;
	Boolean				mTreatAsVMRequest;
#endif
		
	struct
		{
		ulong			curClientBlock;
		const void *	curClientBuffer;
		ulong			blocksRemaining;
		} mWriteStuff;

	DeferredTask		mDecryptDeferredTask;
	DeferredTask		mKickStartDeferredTask;
	
	
	// shared by all drives
	static void *		sScratchBuffer;	// needed for writes only
	static ulong		sScratchBufferSize;
	
	
	Boolean				mBreakUpPBs;
	TunerStruct			mReadTuner;
	TunerStruct			mWriteTuner;
	UInt32				mDriveDeleteTime;
	
	
	OSErr	InitExtents( const DiskExtent * src, ulong numExtents );
	OSErr	InitCipherContext(const CASTKey * key, const PassphraseSalt *salt);
	OSErr	InitVolumeInfo( short fileRefNum );
	
	
	MyPB *	GetIndPB( ushort index );
	void	ReadPBs( ushort	numPBs );
	void	QueueAllPBsForRead( ushort numPBs );
	
	short	GetBaseDriverRefNum( void ) const	{ return( mBaseDriverRefNum ); }
	
	ushort			GetNumExtents( void ) const	{ return( mNumExtents ); }
	const DiskExtent *	FindExtentContainingBlock( ulong blockIndex,
					ulong *startBlockOfExtentPtr);
	
	void	InitReadOrWrite( ParamBlockRec * pb, DCtlEntry * dce,
					IODirection );
	Boolean	IsValidRequest( const IOParam *pb);
	
	void	UpdatePBAndCallIODone( OSErr err, ulong actualCount );
	void	MyIOIsDone( OSErr err, ulong actualCount );
	
	void	SetPosOffset( XIOPB *	pb, ulong startBlockOffset,
					ulong numBlocks);
	void	FillInPB( MyPB * ioPB, const void * src, Ptr dest,
					ulong startBlock, ulong numBlocks );
	ulong	GetBlockLimitForSize( const TunerStruct * tuner, ulong numBlocks);
	void	InsertPB( ushort pbIndex, ushort numPBs, const MyPB * myPB );
	void	InsertLastPB( const ushort index );
	
	void	BreakUpPB( MyPB *in, MyPB *out, ulong firstPieceBlocks = 0);
	Boolean	BreakUpPBIfNeeded( ulong clientRequestSize, MyPB *in, MyPB *out,
					const TunerStruct *tuner);
	ulong	BreakUpPBs(	ulong clientRequestSize, ushort numPBs,
					const TunerStruct *tuner);
	void	BreakUpPBsIfNeeded( ulong clientRequestSize, ushort numPBsIn,
						ushort * numPBsOut, const TunerStruct *tuner);
	
	void	FillInAllPBsForRead( UInt32 offsetInBlocks, ulong numBlocks,
						void * buffer, ushort *	numPBsUsed );
	void	DecryptPB( const MyPB *myPB );


	void					DecryptBlocksDeferredTask( void );
	static pascal void		sDecryptBlocksDeferredTask( void );
	
	static pascal void		sKickStartDeferredTask( void );
	void				KickStartDeferredRead( void );
	void				KickStartDeferredWrite( void );
	
	
	void		InstallDeferredTask( DeferredTask* task,
						DeferredTaskUPP proc );
	
	void		InitWrite( const IOParam *pb );
	void		QueueForEncryption( void );
	void		EncryptAndWriteQueuedItems( void );
	
	static pascal void	sCompletionProc( void );
	void		HandleReadCompletion( MyPB *pb );
	void		HandleWriteCompletion( MyPB *pb );
	void		HandleCompletion( MyPB *pb );
	
	IODirection	GetIODirection( void ) const	{ return( mIODirection ); }
	
	void					FlipBytes( void *bytes, ulong numBytes );
	const CipherContext *	GetCipherContext( void );
	
	
						CDrive( void );
	OSStatus	Init( const InitInfo *info );
	
	
	static CCloseQueue *			sCloseQueue;
	static CChangeModDateQueue *	sModDateQueue;
	static OSErr					sCreateSharedQueues( void );
	
public:
	#if PGP_DEBUG
	static void		sAssertValid( const CDrive *drive );
	#else
	static void		sAssertValid( const CDrive * )	{}
	#endif
	static void				sCleanup( void );
	
	enum { kPBSize = sizeof( MyPB ) };
	
	static OSErr	sCreate( CDrive **newDrive, const InitInfo *info );
	
	virtual			~CDrive( void );
	
	// informational "Get" routines
	short	GetBaseDriveNumber( void ) const
					{ return( mBaseDriveNumber ); }
	short	GetDriveNumber( void ) const
					{ return( mMyDQE->el.dQDrive ); }
	short	GetDriverRefNum( void ) const
					{ return( mMyDQE->el.dQRefNum ); }
	short	GetFileRefNum( void ) const
					{ return( mFileRefNum ); }
	Boolean	GetBreaksUpRequests( void ) const
					{ return( mBreakUpPBs ); }
	const FlagsDrvQEl *	GetDriveQElem( void ) const
					{ return( mMyDQE ); }
	const VCB *	GetVCB( void ) const
					{ return( mVCB ); }
	void		SetVCB( const VCB *vcb )
					{ mVCB = vcb; }
	
	void	Read( ParamBlockRec *pb, DCtlPtr dce );
	void	Write( ParamBlockRec *pb, DCtlPtr dce );
	
	ulong	GetLastAccessTime( void ) const	{	return( mLastAccessTime ); }
	void	SetDriveQElement(const FlagsDrvQEl *queueElement);
	
	ulong			GetLogicalSizeInBlocks( void ) const;
	const char *	GetPhysicalIcon( void ) const;
	const char *	GetMediaIcon( void ) const;
	Boolean			IsWriteProtected( void ) const
							{ return( mWriteProtected ); }
	
	static void		sSetScratchBuffer( void *buffer, ulong bufferSize );
	
	
	void			SetPBs( void *pbArray, ushort numPBs );
	
	void			SetReadTuner( const TunerStruct *tune );
	void			SetWriteTuner( const TunerStruct *tune );
	void			GetReadTuner( TunerStruct *tune )
							{ *tune	= mReadTuner; }
	void			GetWriteTuner( TunerStruct *tune )
							{ *tune	= mWriteTuner; }
	
	void			ToggleKeyBits( void );

	Boolean			HasBeenMounted( void )
							{ return( mHasBeenMounted ); }
	void			SetHasBeenMounted( void )
							{ mHasBeenMounted	= TRUE; }
	ProcessSerialNumber	GetUnmountedAppPSN(void)
							{ return( mUnmountedAppPSN ); }
	void			SetUnmountedAppPSN(ProcessSerialNumber appPSN)
							{ mUnmountedAppPSN = appPSN; }
	UInt32			GetDriveDeleteTime(void)
							{ return( mDriveDeleteTime ); }
	void			SetDriveDeleteTime(UInt32 driveDeleteTime)
							{ mDriveDeleteTime = driveDeleteTime; }
	
	void			UpdateFileModificationDate( void );
	
	void				CheckBaseDriveEjected( ConstStr255Param templateMsg );
	};





